/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core.events;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.core.events.EventQueue;
import org.cloudbus.cloudsim.core.events.SimEvent;

public class FutureQueue
implements EventQueue {
    private final SortedSet<SimEvent> sortedSet = new TreeSet<SimEvent>();
    private long serial;
    private long maxEventsNumber;

    @Override
    public void addEvent(SimEvent newEvent) {
        newEvent.setSerial(this.serial++);
        this.sortedSet.add(newEvent);
        this.maxEventsNumber = Math.max(this.maxEventsNumber, (long)this.sortedSet.size());
    }

    public void addEventFirst(SimEvent newEvent) {
        newEvent.setSerial(0L);
        this.sortedSet.add(newEvent);
    }

    @Override
    public Iterator<SimEvent> iterator() {
        return this.sortedSet.iterator();
    }

    @Override
    public Stream<SimEvent> stream() {
        return this.sortedSet.stream();
    }

    @Override
    public int size() {
        return this.sortedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sortedSet.isEmpty();
    }

    public boolean remove(SimEvent event) {
        return this.sortedSet.remove(event);
    }

    public boolean removeAll(Collection<SimEvent> events) {
        return this.sortedSet.removeAll(events);
    }

    public boolean removeIf(Predicate<SimEvent> predicate) {
        return this.sortedSet.removeIf(predicate);
    }

    @Override
    public SimEvent first() throws NoSuchElementException {
        return this.sortedSet.first();
    }

    public void clear() {
        this.sortedSet.clear();
    }

    public long getSerial() {
        return this.serial;
    }

    public long getMaxEventsNumber() {
        return this.maxEventsNumber;
    }
}

