/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters;

import java.util.List;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.datacenters.DatacenterNull;
import org.cloudbus.cloudsim.datacenters.DatacenterPowerSupply;
import org.cloudbus.cloudsim.datacenters.TimeZoned;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.power.models.PowerAware;
import org.cloudbus.cloudsim.resources.DatacenterStorage;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostEventInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Datacenter
extends SimEntity,
PowerAware,
TimeZoned {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)Datacenter.class.getSimpleName());
    public static final Datacenter NULL = new DatacenterNull();
    public static final double DEF_BW_PERCENT_FOR_MIGRATION = 0.5;

    public void requestVmMigration(Vm var1, Host var2);

    public <T extends Host> List<T> getHostList();

    public Host getHost(int var1);

    public long getActiveHostsNumber();

    public long size();

    public Host getHostById(long var1);

    public <T extends Host> Datacenter addHostList(List<T> var1);

    public <T extends Host> Datacenter addHost(T var1);

    public <T extends Host> Datacenter removeHost(T var1);

    public VmAllocationPolicy getVmAllocationPolicy();

    public double getSchedulingInterval();

    public Datacenter setSchedulingInterval(double var1);

    public DatacenterCharacteristics getCharacteristics();

    public DatacenterStorage getDatacenterStorage();

    public void setDatacenterStorage(DatacenterStorage var1);

    public double getBandwidthPercentForMigration();

    public void setBandwidthPercentForMigration(double var1);

    @Override
    public double getPower();

    public Datacenter addOnHostAvailableListener(EventListener<HostEventInfo> var1);

    public boolean isMigrationsEnabled();

    public Datacenter enableMigrations();

    public Datacenter disableMigrations();

    public void setPowerSupply(DatacenterPowerSupply var1);

    public DatacenterPowerSupply getPowerSupply();

    public double getHostSearchForMigrationDelay();

    public Datacenter setHostSearchRetryDelay(double var1);
}

