/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters;

import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.power.models.PowerAware;

public class DatacenterPowerSupply
implements PowerAware {
    public static final DatacenterPowerSupply NULL = new DatacenterPowerSupply(Datacenter.NULL){

        @Override
        protected double computePowerUtilizationForTimeSpan(double lastDatacenterProcessTime) {
            return -1.0;
        }

        @Override
        public double getPower() {
            return -1.0;
        }
    };
    private Datacenter datacenter;
    private double power;

    public DatacenterPowerSupply() {
    }

    protected DatacenterPowerSupply(Datacenter datacenter) {
        this.datacenter = datacenter;
    }

    protected double computePowerUtilizationForTimeSpan(double lastDatacenterProcessTime) {
        double clock = this.datacenter.getSimulation().clock();
        if (clock - lastDatacenterProcessTime == 0.0) {
            return 0.0;
        }
        double datacenterTimeSpanPowerUse = 0.0;
        for (Host host : this.datacenter.getHostList()) {
            double prevCpuUsage = host.getPreviousUtilizationOfCpu();
            double cpuUsage = host.getCpuPercentUtilization();
            double timeFrameHostEnergy = host.getPowerModel().getEnergyLinearInterpolation(prevCpuUsage, cpuUsage, clock - lastDatacenterProcessTime);
            datacenterTimeSpanPowerUse += timeFrameHostEnergy;
        }
        this.power += datacenterTimeSpanPowerUse;
        return datacenterTimeSpanPowerUse;
    }

    @Override
    public double getPower() {
        return this.power;
    }

    protected DatacenterPowerSupply setDatacenter(Datacenter datacenter) {
        this.datacenter = datacenter;
        return this;
    }
}

