/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import java.util.Objects;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.power.models.PowerModel;

public abstract class PowerModelAbstract
implements PowerModel {
    private Host host;

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public final void setHost(Host host) {
        this.host = Objects.requireNonNull(host);
    }

    @Override
    public double getPower() {
        return this.getPower(this.host.getCpuPercentUtilization());
    }

    @Override
    public final double getPower(double utilization) throws IllegalArgumentException {
        if (utilization < 0.0 || utilization > 1.0) {
            throw new IllegalArgumentException(String.format("Utilization value must be between 0 and 1. The given value was %f", utilization));
        }
        if (!this.host.isActive()) {
            return 0.0;
        }
        return this.getPowerInternal(utilization);
    }

    protected abstract double getPowerInternal(double var1) throws IllegalArgumentException;

    @Override
    public double getEnergyLinearInterpolation(double fromUtilization, double toUtilization, double time) {
        if (!this.host.isActive()) {
            return 0.0;
        }
        double fromPower = this.getPower(fromUtilization);
        double toPower = this.getPower(toUtilization);
        return (fromPower + (toPower - fromPower) / 2.0) * time;
    }
}

