/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.cloudbus.cloudsim.power.models.PowerModelAbstract;

public class PowerModelSimple
extends PowerModelAbstract {
    private static final double ONE_HUNDRED = 100.0;
    private final UnaryOperator<Double> powerFunction;
    private double maxPower;
    private double staticPowerPercent;

    public PowerModelSimple(double maxPower, double staticPowerPercent, UnaryOperator<Double> powerFunction) {
        this.powerFunction = Objects.requireNonNull(powerFunction);
        this.setMaxPower(maxPower);
        this.setStaticPowerPercent(staticPowerPercent);
    }

    @Override
    public double getMaxPower() {
        return this.maxPower;
    }

    private void setMaxPower(double maxPower) {
        if (maxPower < 0.0) {
            throw new IllegalArgumentException("Maximum power consumption cannot be negative.");
        }
        this.maxPower = maxPower;
    }

    public double getStaticPowerPercent() {
        return this.staticPowerPercent;
    }

    private void setStaticPowerPercent(double staticPowerPercent) {
        if (staticPowerPercent < 0.0 || staticPowerPercent > 1.0) {
            throw new IllegalArgumentException("Static power percentage must be between 0 and 1.");
        }
        this.staticPowerPercent = staticPowerPercent;
    }

    public final double getStaticPower() {
        return this.staticPowerPercent * this.maxPower;
    }

    protected double getConstant() {
        return (this.maxPower - this.getStaticPower()) / (Double)this.powerFunction.apply(100.0);
    }

    @Override
    protected double getPowerInternal(double utilization) throws IllegalArgumentException {
        return this.getStaticPower() + this.getConstant() * (Double)this.powerFunction.apply(utilization * 100.0);
    }
}

