/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.provisioners;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;

public abstract class ResourceProvisionerAbstract
implements ResourceProvisioner {
    private ResourceManageable resource;
    private final Map<Vm, Long> resourceAllocationMap;
    private Class<? extends ResourceManageable> resourceClass;

    protected ResourceProvisionerAbstract() {
        this(ResourceManageable.NULL);
    }

    public ResourceProvisionerAbstract(ResourceManageable resource) {
        this.setResource(resource);
        this.resourceAllocationMap = new HashMap<Vm, Long>();
    }

    @Override
    public long getAllocatedResourceForVm(Vm vm) {
        return this.resourceAllocationMap.getOrDefault(vm, 0L);
    }

    @Override
    public void deallocateResourceForAllVms() {
        for (Vm vm : this.resourceAllocationMap.keySet()) {
            this.deallocateResourceForVmAndSetAllocationMapEntryToZero(vm);
        }
        this.getResourceAllocationMap().clear();
    }

    protected abstract long deallocateResourceForVmAndSetAllocationMapEntryToZero(Vm var1);

    @Override
    public ResourceManageable getResource() {
        return this.resource;
    }

    @Override
    public final void setResource(ResourceManageable resource) {
        this.resource = Objects.requireNonNull(resource);
        this.resourceClass = resource.getClass();
    }

    protected Class<? extends ResourceManageable> getResourceClass() {
        return this.resourceClass;
    }

    protected Map<Vm, Long> getResourceAllocationMap() {
        return this.resourceAllocationMap;
    }

    @Override
    public long getCapacity() {
        return this.resource.getCapacity();
    }

    @Override
    public long getTotalAllocatedResource() {
        return this.resource.getAllocatedResource();
    }

    @Override
    public long getAvailableResource() {
        return this.resource.getAvailableResource();
    }

    @Override
    public boolean isResourceAllocatedToVm(Vm vm) {
        return this.resourceAllocationMap.keySet().contains(vm);
    }
}

