/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.resources.File;
import org.cloudbus.cloudsim.resources.FileStorage;

public class DatacenterStorage {
    private List<FileStorage> storageList;
    private Datacenter datacenter;

    public DatacenterStorage() {
        this(new ArrayList<FileStorage>());
    }

    public DatacenterStorage(List<FileStorage> storageList) {
        this.storageList = storageList;
    }

    public boolean contains(File file) {
        return this.contains(Objects.requireNonNull(file).getName());
    }

    public boolean contains(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        return this.storageList.stream().anyMatch(storage -> storage.contains(fileName));
    }

    public List<FileStorage> getStorageList() {
        return Collections.unmodifiableList(this.storageList);
    }

    public final DatacenterStorage setStorageList(List<FileStorage> storageList) {
        this.storageList = Objects.requireNonNull(storageList);
        this.setAllFilesOfAllStoragesToThisDatacenter();
        return this;
    }

    public void setAllFilesOfAllStoragesToThisDatacenter() {
        this.storageList.stream().map(FileStorage::getFileList).flatMap(Collection::stream).forEach(file -> file.setDatacenter(this.getDatacenter()));
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    public void setDatacenter(Datacenter datacenter) {
        this.datacenter = datacenter;
    }

    public double predictFileTransferTime(List<String> requiredFiles) {
        double totalTime = 0.0;
        for (String fileName : requiredFiles) {
            totalTime += Math.max(this.timeToTransferFileFromStorage(fileName), 0.0);
        }
        return totalTime;
    }

    private double timeToTransferFileFromStorage(String fileName) {
        for (FileStorage storage : this.getStorageList()) {
            double transferTime = storage.getTransferTime(fileName);
            if (transferTime == -1.0) continue;
            return transferTime;
        }
        return -1.0;
    }

    public int addFile(File file) {
        Objects.requireNonNull(file);
        if (this.contains(file.getName())) {
            return 523;
        }
        if (this.getStorageList().isEmpty()) {
            return 521;
        }
        for (FileStorage storage : this.getStorageList()) {
            if (!storage.isAmountAvailable(file.getSize())) continue;
            storage.addFile(file);
            return 520;
        }
        return 521;
    }
}

