/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies;

import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSelectionPolicyRandomSelection
implements VmSelectionPolicy {
    private final ContinuousDistribution rand;

    public VmSelectionPolicyRandomSelection() {
        this(new UniformDistr());
    }

    public VmSelectionPolicyRandomSelection(ContinuousDistribution rand) {
        this.rand = Objects.requireNonNull(rand);
    }

    @Override
    public Vm getVmToMigrate(Host host) {
        List<Vm> migratableVms = host.getMigratableVms();
        if (migratableVms.isEmpty()) {
            return Vm.NULL;
        }
        int index = (int)this.rand.sample() * migratableVms.size();
        return migratableVms.get(index);
    }
}

