/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.cloudsimplus.traces.TraceReaderBase;

abstract class GoogleTraceReaderAbstract<T>
extends TraceReaderBase {
    static final String VAL_SEPARATOR = " -> ";
    static final String COL_SEPARATOR = " | ";
    private final Set<T> availableObjects;

    GoogleTraceReaderAbstract(String filePath, InputStream reader) {
        super(filePath, reader);
        this.setFieldDelimiterRegex(",");
        this.availableObjects = new HashSet<T>();
    }

    public Set<T> process() {
        this.preProcess();
        if (this.availableObjects.isEmpty()) {
            try {
                this.readFile(this::processParsedLine);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when processing the trace file. Current trace line: " + this.getLastLineNumber(), e);
            }
            this.postProcess();
        }
        return this.availableObjects;
    }

    protected abstract void preProcess();

    protected abstract void postProcess();

    final boolean processParsedLine(String[] parsedLineArray) {
        this.setLastParsedLineArray(parsedLineArray);
        return this.processParsedLineInternal();
    }

    protected abstract boolean processParsedLineInternal();

    String formatPercentValue(double percent) {
        return String.format("%.1f", percent * 100.0);
    }

    final boolean addAvailableObject(T object) {
        return this.availableObjects.add(Objects.requireNonNull(object));
    }
}

