/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import org.cloudbus.cloudsim.core.AbstractMachineNull;
import org.cloudbus.cloudsim.core.ChangeableId;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.Resourceful;

public interface AbstractMachine
extends ChangeableId,
Resourceful {
    public static final AbstractMachine NULL = new AbstractMachineNull();

    public Resource getBw();

    public Resource getRam();

    public Resource getStorage();

    public long getNumberOfPes();

    public double getMips();

    public double getTotalMipsCapacity();

    public Simulation getSimulation();

    default public boolean isIdleEnough(double time) {
        if (time < 0.0) {
            return false;
        }
        return this.getIdleInterval() >= time;
    }

    default public double getIdleInterval() {
        return this.getSimulation().clock() - this.getLastBusyTime();
    }

    public double getLastBusyTime();

    default public boolean isIdle() {
        return this.getIdleInterval() > 0.0;
    }

    public static void validateCapacity(double capacity) {
        if (capacity <= 0.0) {
            throw new IllegalArgumentException("Capacity must be greater than zero");
        }
    }
}

