/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.distributions;

import org.apache.commons.math3.random.RandomGenerator;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.ParetoDistr;
import org.cloudbus.cloudsim.distributions.StatisticalDistribution;

public class LomaxDistr
extends ParetoDistr
implements ContinuousDistribution {
    private long seed;
    private final double shift;

    public LomaxDistr(double shape, double location, double shift) {
        this(shape, location, shift, StatisticalDistribution.defaultSeed());
    }

    public LomaxDistr(double shape, double location, double shift, long seed) {
        this(shape, location, shift, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public LomaxDistr(double shape, double location, double shift, long seed, RandomGenerator rng) {
        super(shape, location, seed, rng);
        if (shift > location) {
            throw new IllegalArgumentException("Shift must be smaller or equal than location");
        }
        if (seed < 0L) {
            throw new IllegalArgumentException("Seed cannot be negative");
        }
        this.shift = shift;
        this.seed = seed;
    }

    @Override
    public double sample() {
        return super.sample() - this.shift;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }
}

