/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.topologies;

import java.util.Objects;
import org.cloudbus.cloudsim.network.topologies.Point2D;

public class TopologicalNode {
    private int id;
    private String nodeName;
    private Point2D worldCoordinates;

    public TopologicalNode() {
        this(0);
    }

    public TopologicalNode(int id) {
        this(id, new Point2D());
    }

    public TopologicalNode(int id, Point2D worldCoordinates) {
        this(id, String.valueOf(id), worldCoordinates);
    }

    public TopologicalNode(int id, String nodeName, Point2D worldCoordinates) {
        this.worldCoordinates = Objects.requireNonNull(worldCoordinates);
        this.id = id;
        this.nodeName = nodeName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Point2D getWorldCoordinates() {
        return this.worldCoordinates;
    }

    public void setWorldCoordinates(Point2D worldCoordinates) {
        this.worldCoordinates = worldCoordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologicalNode other = (TopologicalNode)o;
        return other.id == this.id;
    }

    public int hashCode() {
        return 31 * Long.hashCode(this.id);
    }
}

