/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies;

import java.util.List;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSelectionPolicyMinimumMigrationTime
implements VmSelectionPolicy {
    @Override
    public Vm getVmToMigrate(Host host) {
        List<Vm> migratableVms = host.getMigratableVms();
        if (migratableVms.isEmpty()) {
            return Vm.NULL;
        }
        Vm vmToMigrate = Vm.NULL;
        double minMetric = Double.MAX_VALUE;
        for (Vm vm : migratableVms) {
            double metric;
            if (vm.isInMigration() || !((metric = (double)vm.getRam().getCapacity()) < minMetric)) continue;
            minMetric = metric;
            vmToMigrate = vm;
        }
        return vmToMigrate;
    }
}

