/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSelectionPolicyMinimumUtilization
implements VmSelectionPolicy {
    @Override
    public Vm getVmToMigrate(Host host) {
        List<Vm> migratableVms = host.getMigratableVms();
        if (migratableVms.isEmpty()) {
            return Vm.NULL;
        }
        Predicate<Vm> inMigration = Vm::isInMigration;
        Comparator<Vm> cpuUsageComparator = Comparator.comparingDouble(vm -> vm.getCpuPercentUtilization(vm.getSimulation().clock()));
        Optional<Vm> optional = migratableVms.stream().filter(inMigration.negate()).min(cpuUsageComparator);
        return optional.isPresent() ? optional.get() : Vm.NULL;
    }
}

