/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.cloudbus.cloudsim.util.TraceReader;

public abstract class TraceReaderAbstract
implements TraceReader {
    private final String filePath;
    private final InputStream inputStream;
    private String fieldDelimiterRegex;
    private int maxLinesToRead;
    private String[] commentString = new String[]{";", "#"};
    private int lastLineNumber;

    public TraceReaderAbstract(String filePath) throws IOException {
        this(filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
    }

    protected TraceReaderAbstract(String filePath, InputStream inputStream) {
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("Invalid trace file name.");
        }
        this.fieldDelimiterRegex = "\\s+";
        this.maxLinesToRead = -1;
        this.inputStream = inputStream;
        this.filePath = filePath;
    }

    @Override
    public TraceReader setCommentString(String ... commentString) {
        if (Objects.requireNonNull(commentString).length == 0) {
            throw new IllegalArgumentException("A comment String is required");
        }
        this.commentString = Arrays.copyOf(commentString, commentString.length);
        return this;
    }

    @Override
    public String[] getCommentString() {
        return Arrays.copyOf(this.commentString, this.commentString.length);
    }

    @Override
    public String getFieldDelimiterRegex() {
        return this.fieldDelimiterRegex;
    }

    @Override
    public final TraceReader setFieldDelimiterRegex(String fieldDelimiterRegex) {
        this.fieldDelimiterRegex = fieldDelimiterRegex;
        return this;
    }

    @Override
    public int getMaxLinesToRead() {
        return this.maxLinesToRead;
    }

    @Override
    public TraceReader setMaxLinesToRead(int maxLinesToRead) {
        this.maxLinesToRead = maxLinesToRead;
        return this;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected String[] parseTraceLine(String line) {
        if (this.isComment(line)) {
            return new String[0];
        }
        return line.trim().split(this.fieldDelimiterRegex, -1);
    }

    private boolean isComment(String line) {
        return Arrays.stream(this.commentString).anyMatch(line::startsWith);
    }

    protected void readTextFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        this.readFile(inputStream, processParsedLineFunction);
    }

    protected void readGZIPFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        this.readFile(new GZIPInputStream(inputStream), processParsedLineFunction);
    }

    protected boolean readZipFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(Objects.requireNonNull(inputStream));){
            while (zipInputStream.getNextEntry() != null) {
                this.readFile(zipInputStream, processParsedLineFunction);
            }
            boolean bl = true;
            return bl;
        }
    }

    protected void readFile(Function<String[], Boolean> processParsedLineFunction) {
        try {
            if (this.getFilePath().endsWith(".gz")) {
                this.readGZIPFile(this.getInputStream(), processParsedLineFunction);
            } else if (this.getFilePath().endsWith(".zip")) {
                this.readZipFile(this.getInputStream(), processParsedLineFunction);
            } else {
                this.readTextFile(this.getInputStream(), processParsedLineFunction);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void readFile(InputStream inputStream, Function<String[], Boolean> processParsedLineFunction) throws IOException {
        String line;
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(processParsedLineFunction);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        this.lastLineNumber = 0;
        while ((line = this.readNextLine(reader, this.lastLineNumber)) != null) {
            String[] parsedTraceLine = this.parseTraceLine(line);
            if (parsedTraceLine.length <= 0 || !processParsedLineFunction.apply(parsedTraceLine).booleanValue()) continue;
            ++this.lastLineNumber;
        }
    }

    private String readNextLine(BufferedReader reader, int lineNumber) throws IOException {
        if (reader.ready() && (this.maxLinesToRead == -1 || lineNumber <= this.maxLinesToRead - 1)) {
            return reader.readLine();
        }
        return null;
    }

    @Override
    public int getLastLineNumber() {
        return this.lastLineNumber;
    }
}

