/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.vms;

import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.cloudbus.cloudsim.core.AbstractMachine;

public abstract class AbstractResourceStats<T extends AbstractMachine> {
    private final Function<T, Double> resourceUtilizationFunction;
    private final T machine;
    private final SummaryStatistics stats;
    private double previousTime;
    private double previousUtilization;

    public AbstractResourceStats(T machine, Function<T, Double> resourceUtilizationFunction) {
        this.resourceUtilizationFunction = Objects.requireNonNull(resourceUtilizationFunction);
        this.machine = (AbstractMachine)Objects.requireNonNull(machine);
        this.stats = new SummaryStatistics();
    }

    public void add(double time) {
        if (this.isNotTimeToAddHistory(time)) {
            return;
        }
        double utilization = this.resourceUtilizationFunction.apply(this.machine);
        if (utilization == 0.0 && this.previousUtilization != 0.0 || this.machine.isIdle()) {
            this.previousUtilization = utilization;
            return;
        }
        double normalizedTime = this.machine.isIdle() ? time : (double)((int)time);
        this.stats.addValue(utilization);
        this.previousTime = normalizedTime;
        this.previousUtilization = utilization;
    }

    public double getMin() {
        return this.stats.getMin();
    }

    public double getMax() {
        return this.stats.getMax();
    }

    public double getMean() {
        return this.stats.getMean();
    }

    public double getStandardDeviation() {
        return this.stats.getStandardDeviation();
    }

    public double getVariance() {
        return this.stats.getVariance();
    }

    public double count() {
        return this.stats.getN();
    }

    public boolean isEmpty() {
        return this.count() == 0.0;
    }

    protected final boolean isNotTimeToAddHistory(double time) {
        return time <= 0.0 || this.isElapsedTimeSmall(time) || this.isNotEntireSecondElapsed(time);
    }

    protected final boolean isElapsedTimeSmall(double time) {
        return time - this.previousTime < 1.0 && !this.machine.isIdle();
    }

    protected final boolean isNotEntireSecondElapsed(double time) {
        return Math.floor(time) == this.previousTime && !this.machine.isIdle();
    }
}

