/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.List;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.Identifiable;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableBuilderAbstract;
import org.cloudsimplus.builders.tables.TableColumn;

public class CloudletsTableBuilder
extends TableBuilderAbstract<Cloudlet> {
    private static final String TIME_FORMAT = "%.0f";
    private static final String SECONDS = "Seconds";
    private static final String CPU_CORES = "CPU cores";

    public CloudletsTableBuilder(List<? extends Cloudlet> list) {
        super(list);
    }

    public CloudletsTableBuilder(List<? extends Cloudlet> list, Table table) {
        super(list, table);
    }

    @Override
    protected void createTableColumns() {
        String ID = "ID";
        this.addColumnDataFunction(this.getTable().addColumn("Cloudlet", "ID"), Identifiable::getId);
        this.addColumnDataFunction(this.getTable().addColumn("Status "), cloudlet -> cloudlet.getStatus().name());
        this.addColumnDataFunction(this.getTable().addColumn("DC", "ID"), cloudlet -> cloudlet.getVm().getHost().getDatacenter().getId());
        this.addColumnDataFunction(this.getTable().addColumn("Host", "ID"), cloudlet -> cloudlet.getVm().getHost().getId());
        this.addColumnDataFunction(this.getTable().addColumn("Host PEs ", CPU_CORES), cloudlet -> cloudlet.getVm().getHost().getWorkingPesNumber());
        this.addColumnDataFunction(this.getTable().addColumn("VM", "ID"), cloudlet -> cloudlet.getVm().getId());
        this.addColumnDataFunction(this.getTable().addColumn("VM PEs   ", CPU_CORES), cloudlet -> cloudlet.getVm().getNumberOfPes());
        this.addColumnDataFunction(this.getTable().addColumn("CloudletLen", "MI"), Cloudlet::getLength);
        this.addColumnDataFunction(this.getTable().addColumn("CloudletPEs", CPU_CORES), Cloudlet::getNumberOfPes);
        TableColumn col = this.getTable().addColumn("StartTime", SECONDS).setFormat(TIME_FORMAT);
        this.addColumnDataFunction(col, Cloudlet::getExecStartTime);
        col = this.getTable().addColumn("FinishTime", SECONDS).setFormat(TIME_FORMAT);
        this.addColumnDataFunction(col, cl -> this.roundTime((Cloudlet)cl, cl.getFinishTime()));
        col = this.getTable().addColumn("ExecTime", SECONDS).setFormat(TIME_FORMAT);
        this.addColumnDataFunction(col, cl -> this.roundTime((Cloudlet)cl, cl.getActualCpuTime()));
    }

    private double roundTime(Cloudlet cloudlet, double time) {
        if (time - cloudlet.getExecStartTime() < 1.0) {
            return time;
        }
        double startFraction = cloudlet.getExecStartTime() - (double)((int)cloudlet.getExecStartTime());
        return Math.round(time - startFraction);
    }
}

