/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.heuristics;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudsimplus.heuristics.Heuristic;
import org.cloudsimplus.heuristics.HeuristicSolution;

public abstract class HeuristicAbstract<S extends HeuristicSolution<?>>
implements Heuristic<S> {
    private final Class<S> solutionClass;
    private final ContinuousDistribution random;
    private int neighborhoodSearchesByIteration;
    private S bestSolutionSoFar;
    private S neighborSolution;
    private double solveTime;

    HeuristicAbstract(ContinuousDistribution random, Class<S> solutionClass) {
        this.solutionClass = solutionClass;
        this.random = random;
        this.neighborhoodSearchesByIteration = 1;
        this.setBestSolutionSoFar(this.newSolutionInstance());
        this.setNeighborSolution(this.bestSolutionSoFar);
    }

    @Override
    public double getSolveTime() {
        return this.solveTime;
    }

    protected void setSolveTime(double solveTime) {
        this.solveTime = solveTime;
    }

    protected ContinuousDistribution getRandom() {
        return this.random;
    }

    private S newSolutionInstance() {
        try {
            Constructor<S> constructor = this.solutionClass.getConstructor(Heuristic.class);
            return (S)((HeuristicSolution)constructor.newInstance(this));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract void updateSystemState();

    @Override
    public int getRandomValue(int maxValue) {
        double uniform = this.getRandom().sample();
        return (int)(uniform >= 1.0 ? uniform % (double)maxValue : uniform * (double)maxValue);
    }

    @Override
    public S solve() {
        long startTime = System.currentTimeMillis();
        this.setBestSolutionSoFar(this.getInitialSolution());
        while (!this.isToStopSearch()) {
            this.searchSolutionInNeighborhood();
            this.updateSystemState();
        }
        this.setSolveTime((double)(System.currentTimeMillis() - startTime) / 1000.0);
        return this.getBestSolutionSoFar();
    }

    private void searchSolutionInNeighborhood() {
        for (int i = 0; i < this.getNeighborhoodSearchesByIteration(); ++i) {
            this.setNeighborSolution(this.createNeighbor(this.getBestSolutionSoFar()));
            if (!(this.getAcceptanceProbability() > (double)this.getRandomValue(1))) continue;
            this.setBestSolutionSoFar(this.getNeighborSolution());
        }
    }

    @Override
    public S getBestSolutionSoFar() {
        return this.bestSolutionSoFar;
    }

    @Override
    public S getNeighborSolution() {
        return this.neighborSolution;
    }

    protected final void setBestSolutionSoFar(S solution) {
        this.bestSolutionSoFar = solution;
    }

    protected final void setNeighborSolution(S neighborSolution) {
        this.neighborSolution = neighborSolution;
    }

    @Override
    public int getNeighborhoodSearchesByIteration() {
        return this.neighborhoodSearchesByIteration;
    }

    @Override
    public void setNeighborhoodSearchesByIteration(int neighborhoodSearches) {
        this.neighborhoodSearchesByIteration = neighborhoodSearches;
    }
}

