/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicySimple;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.datacenters.DatacenterSimple;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.testbeds.AbstractExperiment;
import org.cloudsimplus.testbeds.ExperimentRunner;

public abstract class Experiment
extends AbstractExperiment {
    protected final ExperimentRunner runner;
    private final CloudSim simulation;
    private final List<Datacenter> datacenterList;
    private final List<DatacenterBroker> brokerList;
    private final List<Vm> vmList;
    private final List<Cloudlet> cloudletList;
    private final long seed;
    private int datacentersNumber;
    protected int hostsNumber;
    private int brokersNumber;
    private final int index;
    private int lastVmId;
    private int lastCloudletId;
    private Consumer<? extends Experiment> afterExperimentFinish;
    private Consumer<? extends Experiment> afterExperimentBuild;
    private Function<DatacenterBroker, Integer> vmsByBrokerFunction;
    private Supplier<VmAllocationPolicy> vmAllocationPolicySupplier;

    public Experiment(long seed) {
        this(0, null, seed);
    }

    public Experiment(int index, ExperimentRunner runner) {
        this(index, runner, -1L);
    }

    protected Experiment(int index, ExperimentRunner runner, long seed) {
        if (seed == -1L) {
            Objects.requireNonNull(runner);
        }
        this.brokersNumber = 1;
        this.datacentersNumber = 1;
        this.simulation = new CloudSim();
        this.vmList = new ArrayList<Vm>();
        this.index = index;
        this.datacenterList = new ArrayList<Datacenter>();
        this.brokerList = new ArrayList<DatacenterBroker>();
        this.cloudletList = new ArrayList<Cloudlet>();
        this.runner = runner;
        this.afterExperimentFinish = exp -> {};
        this.afterExperimentBuild = exp -> {};
        this.seed = this.validateSeed(seed);
    }

    private long validateSeed(long seed) {
        if (this.runner == null) {
            return seed;
        }
        if (this.runner.isToReuseSeedFromFirstHalfOfExperiments(this.index)) {
            int previousExperiment = this.index - this.runner.halfSimulationRuns();
            seed = this.runner.getSeed(previousExperiment);
        } else {
            seed = this.runner.getBaseSeed() + (long)this.index;
        }
        this.runner.addSeed(seed);
        return seed;
    }

    public final List<Cloudlet> getCloudletList() {
        return Collections.unmodifiableList(this.cloudletList);
    }

    public List<Vm> getVmList() {
        return Collections.unmodifiableList(this.vmList);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public final void run() {
        if (this.vmsByBrokerFunction == null) {
            throw new NullPointerException("You need to set the function that indicates the number of VMs to create for each broker.");
        }
        this.build();
        this.simulation.start();
        this.afterExperimentFinish(this);
        this.printResultsInternal();
    }

    public boolean isFirstExperimentCreated() {
        return this.index == this.runner.getFirstExperimentCreated();
    }

    private void printResultsInternal() {
        if (this.isVerbose()) {
            this.printResults();
        }
    }

    public abstract void printResults();

    protected final void build() {
        this.createDatacenters();
        this.createBrokers();
        this.brokerList.stream().sorted().forEach(b -> {
            this.createAndSubmitVmsInternal((DatacenterBroker)b);
            this.createAndSubmitCloudletsInternal((DatacenterBroker)b);
        });
        this.afterExperimentBuild(this);
    }

    private void createDatacenters() {
        if (this.datacentersNumber <= 0) {
            throw new IllegalStateException("The number of Datacenters to create was not set");
        }
        for (int i = 0; i < this.datacentersNumber; ++i) {
            this.datacenterList.add(this.createDatacenter(i));
        }
    }

    protected Datacenter createDatacenter(int index) {
        return new DatacenterSimple(this.simulation, this.createHosts(), this.newVmAllocationPolicy());
    }

    protected void createBrokers() {
        if (this.brokersNumber <= 0) {
            throw new IllegalStateException("The number of brokers to create was not set");
        }
        for (int i = 0; i < this.brokersNumber; ++i) {
            this.createBrokerAndAddToList();
        }
    }

    protected abstract DatacenterBroker createBroker();

    protected abstract List<Cloudlet> createCloudlets(DatacenterBroker var1);

    protected abstract Cloudlet createCloudlet(DatacenterBroker var1);

    protected List<Vm> createVms(DatacenterBroker broker) {
        int numVms = this.vmsByBrokerFunction.apply(broker);
        ArrayList<Vm> newList = new ArrayList<Vm>(numVms);
        for (int id = this.vmList.size(); id < this.vmList.size() + numVms; ++id) {
            Vm vm = this.createVm(broker, this.nextVmId());
            newList.add(vm);
        }
        return newList;
    }

    protected abstract Vm createVm(DatacenterBroker var1, int var2);

    protected final int nextVmId() {
        return ++this.lastVmId;
    }

    protected final int nextCloudletId() {
        return ++this.lastCloudletId;
    }

    private DatacenterBroker createBrokerAndAddToList() {
        DatacenterBroker broker = this.createBroker();
        this.brokerList.add(broker);
        return broker;
    }

    protected void createAndSubmitCloudletsInternal(DatacenterBroker broker) {
        List<Cloudlet> list = this.createCloudlets(broker);
        this.cloudletList.addAll(list);
        broker.submitCloudletList(list);
    }

    private void createAndSubmitVmsInternal(DatacenterBroker broker) {
        List<Vm> list = this.createVms(broker);
        this.vmList.addAll(list);
        broker.submitVmList(list);
    }

    protected final List<Host> createHosts() {
        if (this.hostsNumber <= 0) {
            throw new IllegalStateException("The number of hosts to create was not set");
        }
        ArrayList<Host> list = new ArrayList<Host>(this.hostsNumber);
        for (int i = 0; i < this.hostsNumber; ++i) {
            list.add(this.createHost(i));
        }
        return list;
    }

    protected abstract Host createHost(int var1);

    public ExperimentRunner getRunner() {
        return this.runner;
    }

    public List<DatacenterBroker> getBrokerList() {
        return this.brokerList;
    }

    public <T extends Experiment> Experiment setAfterExperimentBuild(Consumer<T> afterExperimentBuild) {
        this.afterExperimentBuild = Objects.requireNonNull(afterExperimentBuild);
        return this;
    }

    private <T extends Experiment> void afterExperimentBuild(T experiment) {
        this.afterExperimentBuild.accept(experiment);
    }

    public <T extends Experiment> Experiment setAfterExperimentFinish(Consumer<T> afterExperimentFinishConsumer) {
        this.afterExperimentFinish = Objects.requireNonNull(afterExperimentFinishConsumer);
        return this;
    }

    private <T extends Experiment> void afterExperimentFinish(T experiment) {
        this.afterExperimentFinish.accept(experiment);
    }

    public final CloudSim getSimulation() {
        return this.simulation;
    }

    public int getBrokersNumber() {
        return this.brokersNumber;
    }

    public Experiment setBrokersNumber(int brokersNumber) {
        if (brokersNumber <= 0) {
            throw new IllegalArgumentException("The number of brokers must be greater than 0");
        }
        this.brokersNumber = brokersNumber;
        return this;
    }

    public List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    public long getSeed() {
        return this.seed;
    }

    public String toString() {
        return String.format("Experiment %d", this.index);
    }

    public final void setVmsByBrokerFunction(Function<DatacenterBroker, Integer> vmsByBrokerFunction) {
        this.vmsByBrokerFunction = Objects.requireNonNull(vmsByBrokerFunction);
    }

    protected Function<DatacenterBroker, Integer> getVmsByBrokerFunction() {
        return this.vmsByBrokerFunction;
    }

    protected final void setHostsNumber(int hostsNumber) {
        if (hostsNumber <= 0) {
            throw new IllegalArgumentException("Number of hosts must be greater than zero.");
        }
        this.hostsNumber = hostsNumber;
    }

    public int getDatacentersNumber() {
        return this.datacentersNumber;
    }

    public void setDatacentersNumber(int datacentersNumber) {
        this.datacentersNumber = datacentersNumber;
    }

    public void setVmAllocationPolicySupplier(Supplier<VmAllocationPolicy> vmAllocationPolicySupplier) {
        this.vmAllocationPolicySupplier = Objects.requireNonNull(vmAllocationPolicySupplier);
    }

    protected final VmAllocationPolicy newVmAllocationPolicy() {
        return this.vmAllocationPolicySupplier == null ? new VmAllocationPolicySimple() : this.vmAllocationPolicySupplier.get();
    }
}

