/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces;

import java.io.InputStream;
import java.util.Objects;
import org.cloudbus.cloudsim.util.TraceReaderAbstract;

public abstract class TraceReaderBase
extends TraceReaderAbstract {
    private static final String INT_REGEX = "^-?\\d+$";
    private String[] lastParsedLineArray;

    protected TraceReaderBase(String filePath, InputStream reader) {
        super(filePath, reader);
    }

    protected <T extends Enum> String getFieldValue(T field) {
        return this.lastParsedLineArray[field.ordinal()];
    }

    protected <T extends Enum> double getFieldDoubleValue(T field) {
        return Double.parseDouble(this.getFieldValue(field));
    }

    protected <T extends Enum> double getFieldDoubleValue(T field, double defaultValue) {
        String value = this.getFieldValue(field);
        return value.matches("^-?\\d+(\\.?\\d+)?$") ? Double.parseDouble(value) : defaultValue;
    }

    protected <T extends Enum> int getFieldIntValue(T field) {
        return Integer.parseInt(this.getFieldValue(field));
    }

    protected <T extends Enum> int getFieldIntValue(T field, int defaultValue) {
        String value = this.getFieldValue(field);
        return value.matches(INT_REGEX) ? Integer.parseInt(value) : defaultValue;
    }

    protected <T extends Enum> long getFieldLongValue(T field) {
        return Long.parseLong(this.getFieldValue(field));
    }

    protected <T extends Enum> long getFieldLongValue(T field, long defaultValue) {
        String value = this.getFieldValue(field);
        return value.matches(INT_REGEX) ? Long.parseLong(value) : defaultValue;
    }

    protected String[] getLastParsedLineArray() {
        return this.lastParsedLineArray;
    }

    protected void setLastParsedLineArray(String[] lastParsedLineArray) {
        this.lastParsedLineArray = Objects.requireNonNull(lastParsedLineArray);
    }
}

