/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.migration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigration;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmSimple;

public abstract class VmAllocationPolicyMigrationAbstract
extends VmAllocationPolicyAbstract
implements VmAllocationPolicyMigration {
    public static final double DEF_UNDER_UTILIZATION_THRESHOLD = 0.35;
    private double underUtilizationThreshold = 0.35;
    private VmSelectionPolicy vmSelectionPolicy;
    private final Map<Vm, Host> savedAllocation = new HashMap<Vm, Host>();
    private boolean hostsUnderloaded;
    private boolean hostsOverloaded;

    public VmAllocationPolicyMigrationAbstract(VmSelectionPolicy vmSelectionPolicy) {
        this(vmSelectionPolicy, null);
    }

    public VmAllocationPolicyMigrationAbstract(VmSelectionPolicy vmSelectionPolicy, BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        super(findHostForVmFunction);
        this.setVmSelectionPolicy(vmSelectionPolicy);
    }

    @Override
    public Map<Vm, Host> getOptimizedAllocationMap(List<? extends Vm> vmList) {
        Set<Host> overloadedHosts = this.getOverloadedHosts();
        this.hostsOverloaded = !overloadedHosts.isEmpty();
        this.printOverUtilizedHosts(overloadedHosts);
        this.saveAllocation();
        Map<Vm, Host> migrationMap = this.getMigrationMapFromOverloadedHosts(overloadedHosts);
        this.updateMigrationMapFromUnderloadedHosts(overloadedHosts, migrationMap);
        if (migrationMap.isEmpty()) {
            return migrationMap;
        }
        this.restoreAllocation();
        return migrationMap;
    }

    private void updateMigrationMapFromUnderloadedHosts(Set<Host> overloadedHosts, Map<Vm, Host> migrationMap) {
        Host underloadedHost;
        List<Host> switchedOffHosts = this.getSwitchedOffHosts();
        Set<Host> ignoredSourceHosts = this.getIgnoredHosts(overloadedHosts, switchedOffHosts);
        ignoredSourceHosts.addAll(migrationMap.values());
        Set<Host> ignoredTargetHosts = this.getIgnoredHosts(overloadedHosts, switchedOffHosts);
        int numberOfHosts = this.getHostList().size();
        this.hostsUnderloaded = false;
        while (numberOfHosts != ignoredSourceHosts.size() && (underloadedHost = this.getUnderloadedHost(ignoredSourceHosts)) != Host.NULL) {
            this.hostsUnderloaded = true;
            LOGGER.info("{}: VmAllocationPolicy: Underloaded hosts: {}", (Object)this.getDatacenter().getSimulation().clockStr(), (Object)underloadedHost);
            ignoredSourceHosts.add(underloadedHost);
            ignoredTargetHosts.add(underloadedHost);
            List<? extends Vm> vmsToMigrateFromHost = this.getVmsToMigrateFromUnderUtilizedHost(underloadedHost);
            if (vmsToMigrateFromHost.isEmpty()) continue;
            this.logVmsToBeReallocated(underloadedHost, vmsToMigrateFromHost);
            Map<Vm, Host> newVmPlacement = this.getNewVmPlacementFromUnderloadedHost(vmsToMigrateFromHost, ignoredTargetHosts);
            ignoredSourceHosts.addAll(this.extractHostListFromMigrationMap(newVmPlacement));
            migrationMap.putAll(newVmPlacement);
        }
    }

    private void logVmsToBeReallocated(Host underloadedHost, List<? extends Vm> migratingOutVms) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("{}: VmAllocationPolicy: VMs to be reallocated from the underloaded {}: {}", new Object[]{this.getDatacenter().getSimulation().clockStr(), underloadedHost, this.getVmIds(migratingOutVms)});
        }
    }

    private Set<Host> getIgnoredHosts(Set<Host> overloadedHosts, List<Host> switchedOffHosts) {
        HashSet<Host> ignoredHosts = new HashSet<Host>();
        ignoredHosts.addAll(overloadedHosts);
        ignoredHosts.addAll(switchedOffHosts);
        return ignoredHosts;
    }

    private String getVmIds(List<? extends Vm> vmList) {
        return vmList.stream().map(vm -> String.valueOf(vm.getId())).collect(Collectors.joining(", "));
    }

    private void printOverUtilizedHosts(Set<Host> overloadedHosts) {
        if (!overloadedHosts.isEmpty() && LOGGER.isWarnEnabled()) {
            String hosts = overloadedHosts.stream().map(this::overloadedHostToString).collect(Collectors.joining(System.lineSeparator()));
            LOGGER.warn("{}: VmAllocationPolicy: Overloaded hosts in {}:{}{}", new Object[]{this.getDatacenter().getSimulation().clockStr(), this.getDatacenter(), System.lineSeparator(), hosts});
        }
    }

    private String overloadedHostToString(Host host) {
        return String.format("      Host %d (upper CPU threshold %.2f, current utilization: %.2f)", host.getId(), this.getOverUtilizationThreshold(host), host.getCpuPercentUtilization());
    }

    protected double getPowerDifferenceAfterAllocation(Host host, Vm vm) {
        double powerAfterAllocation = this.getPowerAfterAllocation(host, vm);
        if (powerAfterAllocation > 0.0) {
            return powerAfterAllocation - host.getPowerModel().getPower();
        }
        return 0.0;
    }

    private boolean isNotHostOverloadedAfterAllocation(Host host, Vm vm) {
        VmSimple tempVm = new VmSimple(vm);
        if (!host.createTemporaryVm(tempVm)) {
            return false;
        }
        double usagePercent = this.getHostCpuPercentRequested(host);
        boolean notOverloadedAfterAllocation = !this.isHostOverloaded(host, usagePercent);
        host.destroyTemporaryVm(tempVm);
        return notOverloadedAfterAllocation;
    }

    @Override
    public boolean isHostOverloaded(Host host) {
        return this.isHostOverloaded(host, host.getCpuPercentUtilization());
    }

    private boolean isHostOverloaded(Host host, double cpuUsagePercent) {
        return cpuUsagePercent > this.getOverUtilizationThreshold(host);
    }

    @Override
    public boolean isHostUnderloaded(Host host) {
        return this.getHostCpuPercentRequested(host) < this.getUnderUtilizationThreshold();
    }

    @Override
    protected Optional<Host> defaultFindHostForVm(Vm vm) {
        HashSet<Host> excludedHosts = new HashSet<Host>();
        excludedHosts.add(vm.getHost());
        return this.findHostForVm(vm, excludedHosts);
    }

    private Optional<Host> findHostForVm(Vm vm, Set<? extends Host> excludedHosts) {
        return this.findHostForVm(vm, excludedHosts, host -> true);
    }

    private Optional<Host> findHostForVm(Vm vm, Set<? extends Host> excludedHosts, Predicate<Host> predicate) {
        Stream<Host> stream = this.getHostList().stream().filter(host -> !excludedHosts.contains(host)).filter(host -> host.isSuitableForVm(vm)).filter(host -> this.isNotHostOverloadedAfterAllocation((Host)host, vm)).filter(predicate);
        return this.findHostForVmInternal(vm, stream);
    }

    protected Optional<Host> findHostForVmInternal(Vm vm, Stream<Host> hostStream) {
        Comparator<Host> hostPowerConsumptionComparator = Comparator.comparingDouble(host -> this.getPowerDifferenceAfterAllocation((Host)host, vm));
        return hostStream.min(hostPowerConsumptionComparator);
    }

    private List<Host> extractHostListFromMigrationMap(Map<Vm, Host> migrationMap) {
        return new ArrayList<Host>(migrationMap.values());
    }

    private Map<Vm, Host> getMigrationMapFromOverloadedHosts(Set<Host> overloadedHosts) {
        if (overloadedHosts.isEmpty()) {
            return new HashMap<Vm, Host>();
        }
        List<Vm> vmsToMigrate = this.getVmsToMigrateFromOverloadedHosts(overloadedHosts);
        this.sortByCpuUtilization(vmsToMigrate, this.getDatacenter().getSimulation().clock());
        HashMap<Vm, Host> migrationMap = new HashMap<Vm, Host>();
        StringBuilder builder = new StringBuilder();
        for (Vm vm : vmsToMigrate) {
            this.findHostForVm(vm, overloadedHosts).ifPresent(targetHost -> {
                this.addVmToMigrationMap(migrationMap, vm, targetHost);
                this.appendVmMigrationMsgToStringBuilder(builder, vm, (Host)targetHost);
            });
        }
        LOGGER.info("{}: VmAllocationPolicy: Reallocation of VMs from overloaded hosts: {}{}", new Object[]{this.getDatacenter().getSimulation().clockStr(), System.lineSeparator(), builder.toString()});
        return migrationMap;
    }

    private void appendVmMigrationMsgToStringBuilder(StringBuilder builder, Vm vm, Host targetHost) {
        if (LOGGER.isInfoEnabled()) {
            builder.append("      ").append(vm).append(" will be migrated from ").append(vm.getHost()).append(" to ").append(targetHost).append(System.lineSeparator());
        }
    }

    private Map<Vm, Host> getNewVmPlacementFromUnderloadedHost(List<? extends Vm> vmsToMigrate, Set<? extends Host> excludedHosts) {
        HashMap<Vm, Host> migrationMap = new HashMap<Vm, Host>();
        this.sortByCpuUtilization(vmsToMigrate, this.getDatacenter().getSimulation().clock());
        for (Vm vm : vmsToMigrate) {
            Optional<Host> optional = this.findHostForVm(vm, excludedHosts, host -> !this.isHostUnderloaded((Host)host));
            if (!optional.isPresent()) {
                LOGGER.warn("{}: VmAllocationPolicy: A new Host, which isn't also underloaded or won't be overloaded, couldn't be found to migrate {}. Migration of VMs from the underloaded {} cancelled.", new Object[]{this.getDatacenter().getSimulation().clockStr(), vm, vm.getHost()});
                return new HashMap<Vm, Host>();
            }
            this.addVmToMigrationMap(migrationMap, vm, optional.get());
        }
        return migrationMap;
    }

    private void sortByCpuUtilization(List<? extends Vm> vmList, double simulationTime) {
        Comparator<Vm> comparator = Comparator.comparingDouble(vm -> vm.getTotalCpuMipsUtilization(simulationTime));
        vmList.sort(comparator.reversed());
    }

    private <T extends Host> void addVmToMigrationMap(Map<Vm, T> migrationMap, Vm vm, T targetHost) {
        targetHost.createTemporaryVm(vm);
        migrationMap.put(vm, targetHost);
    }

    private List<Vm> getVmsToMigrateFromOverloadedHosts(Set<Host> overloadedHosts) {
        LinkedList<Vm> vmsToMigrate = new LinkedList<Vm>();
        for (Host host : overloadedHosts) {
            vmsToMigrate.addAll(this.getVmsToMigrateFromOverloadedHost(host));
        }
        return vmsToMigrate;
    }

    private List<Vm> getVmsToMigrateFromOverloadedHost(Host host) {
        Vm vm;
        LinkedList<Vm> vmsToMigrate = new LinkedList<Vm>();
        while (Vm.NULL != (vm = this.getVmSelectionPolicy().getVmToMigrate(host))) {
            vmsToMigrate.add(vm);
            host.destroyTemporaryVm(vm);
            if (this.isHostOverloaded(host)) continue;
            break;
        }
        return vmsToMigrate;
    }

    protected List<? extends Vm> getVmsToMigrateFromUnderUtilizedHost(Host host) {
        return host.getMigratableVms();
    }

    protected List<Host> getSwitchedOffHosts() {
        return this.getHostList().stream().filter(this::isShutdownOrFailed).collect(Collectors.toList());
    }

    private boolean isShutdownOrFailed(Host host) {
        return !host.isActive() || host.isFailed();
    }

    private Set<Host> getOverloadedHosts() {
        return this.getHostList().stream().filter(this::isHostOverloaded).filter(host -> host.getVmsMigratingOut().isEmpty()).collect(Collectors.toSet());
    }

    private Host getUnderloadedHost(Set<? extends Host> excludedHosts) {
        return this.getHostList().stream().filter(host -> !excludedHosts.contains(host)).filter(Host::isActive).filter(this::isHostUnderloaded).filter(host -> host.getVmsMigratingIn().isEmpty()).filter(this::notAllVmsAreMigratingOut).min(Comparator.comparingDouble(Host::getCpuPercentUtilization)).orElse(Host.NULL);
    }

    private double getHostCpuPercentRequested(Host host) {
        return this.getHostTotalRequestedMips(host) / host.getTotalMipsCapacity();
    }

    private double getHostTotalRequestedMips(Host host) {
        return host.getVmList().stream().mapToDouble(Vm::getCurrentRequestedTotalMips).sum();
    }

    private boolean notAllVmsAreMigratingOut(Host host) {
        return host.getVmList().stream().anyMatch(vm -> !vm.isInMigration());
    }

    private void saveAllocation() {
        this.savedAllocation.clear();
        for (Host host : this.getHostList()) {
            for (Vm vm : host.getVmList()) {
                if (host.getVmsMigratingIn().contains(vm)) continue;
                this.savedAllocation.put(vm, host);
            }
        }
    }

    private void restoreAllocation() {
        for (Host host : this.getHostList()) {
            host.destroyAllVms();
            host.reallocateMigratingInVms();
        }
        for (Vm vm : this.savedAllocation.keySet()) {
            Host host = this.savedAllocation.get(vm);
            if (host.createTemporaryVm(vm)) {
                vm.setCreated(true);
                continue;
            }
            LOGGER.error("VmAllocationPolicy: Couldn't restore {} on {}", (Object)vm, (Object)host);
        }
    }

    protected double getPowerAfterAllocation(Host host, Vm vm) {
        try {
            return host.getPowerModel().getPower(this.getMaxUtilizationAfterAllocation(host, vm));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Power consumption for {} could not be determined: {}", (Object)host, (Object)e.getMessage());
            return 0.0;
        }
    }

    protected double getMaxUtilizationAfterAllocation(Host host, Vm vm) {
        double requestedTotalMips = vm.getCurrentRequestedTotalMips();
        double hostUtilizationMips = this.getUtilizationOfCpuMips(host);
        double hostPotentialMipsUse = hostUtilizationMips + requestedTotalMips;
        return hostPotentialMipsUse / host.getTotalMipsCapacity();
    }

    protected double getUtilizationOfCpuMips(Host host) {
        double hostUtilizationMips = 0.0;
        for (Vm vm : host.getVmList()) {
            double additionalMips = this.additionalCpuUtilizationDuringMigration(host, vm);
            hostUtilizationMips += additionalMips + host.getTotalAllocatedMipsForVm(vm);
        }
        return hostUtilizationMips;
    }

    private double additionalCpuUtilizationDuringMigration(Host host, Vm vm) {
        if (!host.getVmsMigratingIn().contains(vm)) {
            return 0.0;
        }
        double maxCpuUtilization = host.getVmScheduler().getMaxCpuUsagePercentDuringOutMigration();
        double migrationOverhead = host.getVmScheduler().getVmMigrationCpuOverhead();
        return host.getTotalAllocatedMipsForVm(vm) * maxCpuUtilization / migrationOverhead;
    }

    @Override
    public final void setVmSelectionPolicy(VmSelectionPolicy vmSelectionPolicy) {
        this.vmSelectionPolicy = Objects.requireNonNull(vmSelectionPolicy);
    }

    @Override
    public VmSelectionPolicy getVmSelectionPolicy() {
        return this.vmSelectionPolicy;
    }

    @Override
    public double getUnderUtilizationThreshold() {
        return this.underUtilizationThreshold;
    }

    @Override
    public void setUnderUtilizationThreshold(double underUtilizationThreshold) {
        if (underUtilizationThreshold <= 0.0 || underUtilizationThreshold >= 1.0) {
            throw new IllegalArgumentException("Under utilization threshold must be greater than 0 and lower than 1.");
        }
        this.underUtilizationThreshold = underUtilizationThreshold;
    }

    @Override
    public final boolean isVmMigrationSupported() {
        return true;
    }

    @Override
    public boolean areHostsUnderloaded() {
        return this.hostsUnderloaded;
    }

    @Override
    public boolean areHostsOverloaded() {
        return this.hostsOverloaded;
    }
}

