/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core.events;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.core.events.EventQueue;
import org.cloudbus.cloudsim.core.events.SimEvent;

public class DeferredQueue
implements EventQueue {
    private final List<SimEvent> list = new LinkedList<SimEvent>();
    private double maxTime = -1.0;
    private int addedToTail;
    private int addedToMiddle;
    private int maxSize;

    @Override
    public void addEvent(SimEvent newEvent) {
        double eventTime = newEvent.getTime();
        this.maxSize = Math.max(this.maxSize, this.list.size());
        if (eventTime >= this.maxTime) {
            this.list.add(newEvent);
            this.maxTime = eventTime;
            ++this.addedToTail;
            return;
        }
        ListIterator<SimEvent> reverseIterator = this.list.listIterator(this.list.size() - 1);
        while (reverseIterator.hasPrevious()) {
            if (!(reverseIterator.previous().getTime() <= eventTime)) continue;
            reverseIterator.next();
            reverseIterator.add(newEvent);
            ++this.addedToMiddle;
            return;
        }
        this.list.add(newEvent);
    }

    @Override
    public Iterator<SimEvent> iterator() {
        return this.list.iterator();
    }

    @Override
    public Stream<SimEvent> stream() {
        return this.list.stream();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean remove(SimEvent event) {
        return this.list.remove(event);
    }

    public boolean removeAll(Collection<SimEvent> events) {
        return this.list.removeAll(events);
    }

    public boolean removeIf(Predicate<SimEvent> predicate) {
        return this.list.removeIf(predicate);
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public SimEvent first() throws NoSuchElementException {
        if (this.list.isEmpty()) {
            throw new NoSuchElementException("The Deferred Queue is empty.");
        }
        return this.list.get(0);
    }

    public int getAddedToTail() {
        return this.addedToTail;
    }

    public int getAddedToMiddle() {
        return this.addedToMiddle;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

