/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.events.PredicateType;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.hosts.network.NetworkHost;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwitch
extends CloudSimEntity
implements Switch {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractSwitch.class.getSimpleName());
    private final Map<Switch, List<HostPacket>> uplinkSwitchPacketMap;
    private final Map<Switch, List<HostPacket>> downlinkSwitchPacketMap;
    private final Map<NetworkHost, List<HostPacket>> packetToHostMap = new HashMap<NetworkHost, List<HostPacket>>();
    private final List<Switch> uplinkSwitches;
    private final List<Switch> downlinkSwitches;
    private double uplinkBandwidth;
    private double downlinkBandwidth;
    private int ports;
    private NetworkDatacenter datacenter;
    private double switchingDelay;

    public AbstractSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation);
        this.uplinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitches = new ArrayList<Switch>();
        this.uplinkSwitches = new ArrayList<Switch>();
        this.datacenter = dc;
    }

    @Override
    protected void startInternal() {
        LOGGER.info("{} is starting...", (Object)this.getName());
        this.schedule(this, 0.0, 4);
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case 43: {
                this.processPacketUp(evt);
                break;
            }
            case 46: {
                this.processPacketDown(evt);
                break;
            }
            case 44: {
                this.processPacketForward();
                break;
            }
            case 47: {
                this.processHostPacket(evt);
            }
        }
    }

    protected void processHostPacket(SimEvent evt) {
        HostPacket pkt = (HostPacket)evt.getData();
        NetworkHost host = pkt.getDestination();
        host.addReceivedNetworkPacket(pkt);
    }

    protected void processPacketDown(SimEvent evt) {
        this.getSimulation().cancelAll(this, new PredicateType(44));
        this.schedule(this, this.getSwitchingDelay(), 44);
    }

    protected NetworkHost getVmHost(Vm vm) {
        return (NetworkHost)vm.getHost();
    }

    protected void processPacketUp(SimEvent evt) {
        this.getSimulation().cancelAll(this, new PredicateType(44));
        this.schedule(this, this.switchingDelay, 44);
    }

    private void processPacketForward() {
        this.forwardPacketsToDownlinkSwitches();
        this.forwardPacketsToUplinkSwitches();
        this.forwardPacketsToHosts();
    }

    private void forwardPacketsToDownlinkSwitches() {
        for (Switch destinationSwitch : this.downlinkSwitchPacketMap.keySet()) {
            List<HostPacket> packetList = this.getDownlinkSwitchPacketList(destinationSwitch);
            double bandwidth = this.downlinkBandwidth;
            this.forwardPacketsToSwitch(destinationSwitch, packetList, bandwidth, 46);
        }
    }

    private void forwardPacketsToSwitch(Switch destinationSwitch, List<HostPacket> packetList, double bandwidth, int cloudSimTag) {
        for (HostPacket pkt : packetList) {
            double delay = this.packetTransferDelay(pkt, bandwidth, packetList.size());
            this.send(destinationSwitch, delay, cloudSimTag, pkt);
        }
        packetList.clear();
    }

    private void forwardPacketsToUplinkSwitches() {
        for (Switch destinationSwitch : this.uplinkSwitchPacketMap.keySet()) {
            List<HostPacket> packetList = this.getUplinkSwitchPacketList(destinationSwitch);
            double bandwidth = this.uplinkBandwidth;
            this.forwardPacketsToSwitch(destinationSwitch, packetList, bandwidth, 43);
        }
    }

    private void forwardPacketsToHosts() {
        for (NetworkHost host : this.packetToHostMap.keySet()) {
            List<HostPacket> packetList = this.getHostPacketList(host);
            this.forwardPacketsToSwitch(this, packetList, this.downlinkBandwidth, 47);
        }
    }

    @Override
    public double downlinkTransferDelay(HostPacket packet, int simultaneousPackets) {
        return this.packetTransferDelay(packet, this.downlinkBandwidth, simultaneousPackets);
    }

    @Override
    public double uplinkTransferDelay(HostPacket packet, int simultaneousPackets) {
        return this.packetTransferDelay(packet, this.uplinkBandwidth, simultaneousPackets);
    }

    protected double packetTransferDelay(HostPacket netPkt, double bwCapacity, int simultaneousPackets) {
        return Conversion.bytesToMegaBits(netPkt.getSize()) / this.bandwidthByPacket(bwCapacity, simultaneousPackets);
    }

    protected double bandwidthByPacket(double bwCapacity, int simultaneousPackets) {
        return simultaneousPackets == 0 ? bwCapacity : bwCapacity / (double)simultaneousPackets;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        LOGGER.info("{} is shutting down...", (Object)this.getName());
    }

    @Override
    public double getUplinkBandwidth() {
        return this.uplinkBandwidth;
    }

    @Override
    public final void setUplinkBandwidth(double uplinkBandwidth) {
        this.uplinkBandwidth = uplinkBandwidth;
    }

    @Override
    public double getDownlinkBandwidth() {
        return this.downlinkBandwidth;
    }

    @Override
    public final void setDownlinkBandwidth(double downlinkBandwidth) {
        this.downlinkBandwidth = downlinkBandwidth;
    }

    @Override
    public int getPorts() {
        return this.ports;
    }

    @Override
    public final void setPorts(int ports) {
        this.ports = ports;
    }

    @Override
    public double getSwitchingDelay() {
        return this.switchingDelay;
    }

    @Override
    public final void setSwitchingDelay(double switchingDelay) {
        this.switchingDelay = switchingDelay;
    }

    @Override
    public List<Switch> getUplinkSwitches() {
        return this.uplinkSwitches;
    }

    @Override
    public List<Switch> getDownlinkSwitches() {
        return this.downlinkSwitches;
    }

    protected List<HostPacket> getDownlinkSwitchPacketList(Switch downlinkSwitch) {
        this.downlinkSwitchPacketMap.putIfAbsent(downlinkSwitch, new ArrayList());
        return this.downlinkSwitchPacketMap.get(downlinkSwitch);
    }

    protected List<HostPacket> getUplinkSwitchPacketList(Switch uplinkSwitch) {
        this.uplinkSwitchPacketMap.putIfAbsent(uplinkSwitch, new ArrayList());
        return this.uplinkSwitchPacketMap.get(uplinkSwitch);
    }

    protected List<HostPacket> getHostPacketList(NetworkHost host) {
        this.packetToHostMap.putIfAbsent(host, new ArrayList());
        return this.packetToHostMap.get(host);
    }

    protected void addPacketToSendToDownlinkSwitch(Switch downlinkSwitch, HostPacket packet) {
        this.getDownlinkSwitchPacketList(downlinkSwitch).add(packet);
    }

    protected void addPacketToSendToUplinkSwitch(Switch uplinkSwitch, HostPacket packet) {
        this.getUplinkSwitchPacketList(uplinkSwitch).add(packet);
    }

    protected void addPacketToSendToHost(NetworkHost host, HostPacket packet) {
        this.getHostPacketList(host).add(packet);
    }

    @Override
    public NetworkDatacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public void setDatacenter(NetworkDatacenter datacenter) {
        this.datacenter = datacenter;
    }

    protected EdgeSwitch getVmEdgeSwitch(HostPacket pkt) {
        Vm receiverVm = pkt.getVmPacket().getDestination();
        return ((NetworkHost)receiverVm.getHost()).getEdgeSwitch();
    }

    protected void addPacketToBeSentToFirstUplinkSwitch(HostPacket netPkt) {
        Switch uplinkSw = this.getUplinkSwitches().get(0);
        this.addPacketToSendToUplinkSwitch(uplinkSw, netPkt);
    }
}

