/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import org.cloudbus.cloudsim.power.PowerMeasurement;
import org.cloudbus.cloudsim.power.models.PowerModelHost;

public class PowerModelHostSimple
extends PowerModelHost {
    private double maxPower;
    private double staticPower;

    public PowerModelHostSimple(double maxPower, double staticPower) {
        if (maxPower < staticPower) {
            throw new IllegalArgumentException("maxPower has to be bigger than staticPower");
        }
        this.maxPower = PowerModelHostSimple.validatePower(maxPower, "maxPower");
        this.staticPower = PowerModelHostSimple.validatePower(staticPower, "staticPower");
    }

    @Override
    public PowerMeasurement getPowerMeasurement() {
        if (!this.getHost().isActive()) {
            return new PowerMeasurement();
        }
        double utilizationFraction = this.getHost().getCpuMipsUtilization() / this.getHost().getTotalMipsCapacity();
        return new PowerMeasurement(this.staticPower, (this.maxPower - this.staticPower) * utilizationFraction);
    }

    @Override
    public double getPower(double utilizationFraction) throws IllegalArgumentException {
        if (utilizationFraction < 0.0 || utilizationFraction > 1.0) {
            throw new IllegalArgumentException("utilizationFraction has to be between [0 and 1]");
        }
        return this.staticPower + (this.maxPower - this.staticPower) * utilizationFraction;
    }

    private static double validatePower(double power, String fieldName) {
        if (power < 0.0) {
            throw new IllegalArgumentException(fieldName + " cannot be negative");
        }
        if (power < 1.0) {
            throw new IllegalArgumentException(fieldName + " must be in watts. A value smaller than 1 may indicate you're trying to give a percentage value instead.");
        }
        return power;
    }

    public double getMaxPower() {
        return this.maxPower;
    }

    public double getStaticPower() {
        return this.staticPower;
    }
}

