/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import java.util.Objects;
import java.util.function.Function;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.VmScalingAbstract;
import org.cloudsimplus.autoscaling.resources.ResourceScaling;
import org.cloudsimplus.autoscaling.resources.ResourceScalingGradual;
import org.cloudsimplus.listeners.VmHostEventInfo;

public class VerticalVmScalingSimple
extends VmScalingAbstract
implements VerticalVmScaling {
    private ResourceScaling resourceScaling;
    private double scalingFactor;
    private Class<? extends ResourceManageable> resourceClassToScale;
    private Function<Vm, Double> upperThresholdFunction;
    private Function<Vm, Double> lowerThresholdFunction;

    public VerticalVmScalingSimple(Class<? extends ResourceManageable> resourceClassToScale, double scalingFactor) {
        this.setResourceScaling(new ResourceScalingGradual());
        this.lowerThresholdFunction = VerticalVmScaling.NULL.getLowerThresholdFunction();
        this.upperThresholdFunction = VerticalVmScaling.NULL.getUpperThresholdFunction();
        this.setResourceClass(resourceClassToScale);
        this.setScalingFactor(scalingFactor);
    }

    @Override
    public Function<Vm, Double> getUpperThresholdFunction() {
        return this.upperThresholdFunction;
    }

    @Override
    public final VerticalVmScaling setUpperThresholdFunction(Function<Vm, Double> upperThresholdFunction) {
        this.validateFunctions(this.lowerThresholdFunction, upperThresholdFunction);
        this.upperThresholdFunction = upperThresholdFunction;
        return this;
    }

    @Override
    public Function<Vm, Double> getLowerThresholdFunction() {
        return this.lowerThresholdFunction;
    }

    @Override
    public final VerticalVmScaling setLowerThresholdFunction(Function<Vm, Double> lowerThresholdFunction) {
        this.validateFunctions(lowerThresholdFunction, this.upperThresholdFunction);
        this.lowerThresholdFunction = lowerThresholdFunction;
        return this;
    }

    @Override
    public final VerticalVmScaling setResourceScaling(ResourceScaling resourceScaling) {
        this.resourceScaling = Objects.requireNonNull(resourceScaling);
        return this;
    }

    @Override
    public long getAllocatedResource() {
        return this.getResource().getAllocatedResource();
    }

    private void validateFunctions(Function<Vm, Double> lowerThresholdFunction, Function<Vm, Double> upperThresholdFunction) {
        Objects.requireNonNull(lowerThresholdFunction);
        Objects.requireNonNull(upperThresholdFunction);
        if (upperThresholdFunction.equals(lowerThresholdFunction)) {
            throw new IllegalArgumentException("Lower and Upper utilization threshold functions cannot be equal.");
        }
    }

    @Override
    public Class<? extends ResourceManageable> getResourceClass() {
        return this.resourceClassToScale;
    }

    @Override
    public final VerticalVmScaling setResourceClass(Class<? extends ResourceManageable> resourceClass) {
        this.resourceClassToScale = Objects.requireNonNull(resourceClass);
        if (Pe.class.equals(this.resourceClassToScale)) {
            this.resourceClassToScale = Processor.class;
        }
        return this;
    }

    @Override
    public double getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public final boolean requestUpScalingIfPredicateMatches(VmHostEventInfo evt) {
        if (!this.isTimeToCheckPredicate(evt.getTime())) {
            return false;
        }
        boolean requestedScaling = (this.isVmUnderloaded() || this.isVmOverloaded()) && this.requestUpScaling(evt.getTime());
        this.setLastProcessingTime(evt.getTime());
        return requestedScaling;
    }

    @Override
    public boolean isVmUnderloaded() {
        return this.getResource().getPercentUtilization() < this.lowerThresholdFunction.apply(this.getVm());
    }

    @Override
    public boolean isVmOverloaded() {
        return this.getResource().getPercentUtilization() > this.upperThresholdFunction.apply(this.getVm());
    }

    @Override
    public Resource getResource() {
        return this.getVm().getResource(this.resourceClassToScale);
    }

    @Override
    public double getResourceAmountToScale() {
        return Math.ceil(this.resourceScaling.getResourceAmountToScale(this));
    }

    @Override
    public Function<Vm, Double> getResourceUsageThresholdFunction() {
        if (this.isVmUnderloaded()) {
            return this.lowerThresholdFunction;
        }
        if (this.isVmOverloaded()) {
            return this.upperThresholdFunction;
        }
        return vm -> 0.0;
    }

    @Override
    public final VerticalVmScaling setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
        return this;
    }

    @Override
    protected boolean requestUpScaling(double time) {
        DatacenterBroker broker = this.getVm().getBroker();
        broker.getSimulation().sendNow(broker, broker, 42, this);
        return true;
    }
}

