/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudsimplus.builders.tables.AbstractTableColumn;
import org.cloudsimplus.builders.tables.Table;

public class HtmlTableColumn
extends AbstractTableColumn {
    public HtmlTableColumn(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public HtmlTableColumn(String title) {
        this(null, title, "");
    }

    public HtmlTableColumn(Table table, String title) {
        super(table, title);
    }

    public HtmlTableColumn(Table table, String title, String subTitle) {
        super(table, title, subTitle);
    }

    private String indentLine(int columnIndex) {
        return columnIndex == 0 ? "    " : "";
    }

    @Override
    protected String generateHeader(String str) {
        int index = this.getTable().getColumns().indexOf(this);
        return String.format("%s<th>%s</th>", this.indentLine(index), str);
    }

    @Override
    public String generateData(Object data) {
        int index = this.getTable().getColumns().indexOf(this);
        return String.format("%s<td>%s</td>", this.indentLine(index), super.generateData(data));
    }
}

