/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.builders.tables.CsvTable;
import org.cloudsimplus.builders.tables.TableColumn;
import org.cloudsimplus.builders.tables.TextTableColumn;

public class TextTable
extends CsvTable {
    public TextTable() {
        this("");
    }

    public TextTable(String title) {
        super(title);
        this.setColumnSeparator("|");
    }

    @Override
    public void printTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.getTitle())) {
            this.getPrintStream().println(this.getCentralizedString(this.getTitle()));
        }
    }

    @Override
    public void printTableOpening() {
        this.getPrintStream().println();
    }

    @Override
    protected void printColumnHeaders() {
        super.printColumnHeaders();
        this.getPrintStream().println(this.createHorizontalLine());
    }

    @Override
    public void printTableClosing() {
        this.getPrintStream().println(this.createHorizontalLine());
    }

    private String getCentralizedString(String str) {
        int indentationLength = (this.getLengthOfColumnHeadersRow() - str.length()) / 2;
        return String.format("%n%s%s%n", StringUtils.repeat((String)" ", (int)indentationLength), str);
    }

    private String createHorizontalLine() {
        return this.stringRepeat(this.getLineSeparator(), this.getLengthOfColumnHeadersRow());
    }

    private String stringRepeat(String str, int timesToRepeat) {
        return new String(new char[timesToRepeat]).replace("\u0000", str);
    }

    private int getLengthOfColumnHeadersRow() {
        return this.getColumns().stream().mapToInt(col -> col.generateTitleHeader().length()).sum();
    }

    @Override
    public String getLineSeparator() {
        return "-";
    }

    @Override
    public TableColumn addColumn(int index, String columnTitle) {
        return this.addColumn(new TextTableColumn(this, columnTitle));
    }
}

