/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.listeners;

import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.DatacenterEventInfo;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmEventInfo;

public interface VmDatacenterEventInfo
extends VmEventInfo,
DatacenterEventInfo {
    public static VmDatacenterEventInfo of(EventListener<? extends EventInfo> listener, Vm vm) {
        return VmDatacenterEventInfo.of(listener, vm, vm.getHost().getDatacenter());
    }

    public static VmDatacenterEventInfo of(final EventListener<? extends EventInfo> listener, final Vm vm, final Datacenter datacenter) {
        final double time = vm.getSimulation().clock();
        return new VmDatacenterEventInfo(){

            @Override
            public Datacenter getDatacenter() {
                return datacenter;
            }

            @Override
            public Vm getVm() {
                return vm;
            }

            @Override
            public double getTime() {
                return time;
            }

            public EventListener<? extends EventInfo> getListener() {
                return listener;
            }
        };
    }
}

