/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import ch.qos.logback.classic.Level;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.StatisticalDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudsimplus.testbeds.AbstractExperiment;
import org.cloudsimplus.testbeds.Experiment;
import org.cloudsimplus.util.Log;

public abstract class ExperimentRunner<T extends Experiment>
extends AbstractExperiment {
    public static final double CONFIDENCE_LEVEL = 0.95;
    private final boolean parallel;
    private int firstExperimentCreated = -1;
    private final long baseSeed;
    private final List<Long> seeds;
    private int simulationRuns;
    private long experimentsStartTimeSecs;
    private long experimentsExecutionTimeSecs;
    private final boolean applyAntitheticVariatesTechnique;
    private int batchesNumber;
    private final Map<String, List<Double>> metricsMap;
    private String description;
    private String resultsTableId;
    private boolean latexTableResultsGeneration;
    private final List<Experiment> experiments;

    protected ExperimentRunner(long baseSeed, int simulationRuns) {
        this(baseSeed, simulationRuns, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, boolean latexTableResultsGeneration, boolean parallel) {
        this(baseSeed, simulationRuns, 0, false, parallel, latexTableResultsGeneration);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, boolean antitheticVariatesTechnique) {
        this(baseSeed, simulationRuns, 0, antitheticVariatesTechnique, false, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, int batchesNumber, boolean antitheticVariatesTechnique) {
        this(baseSeed, simulationRuns, batchesNumber, antitheticVariatesTechnique, false, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, int batchesNumber, boolean antitheticVariatesTechnique, boolean parallel, boolean latexTableResultsGeneration) {
        this.baseSeed = baseSeed;
        this.applyAntitheticVariatesTechnique = antitheticVariatesTechnique;
        if (simulationRuns <= 0) {
            throw new IllegalArgumentException("Simulation runs must be greater than 0.");
        }
        this.simulationRuns = simulationRuns;
        if (batchesNumber < 0) {
            throw new IllegalArgumentException("Batches cannot be negative. Use 0 to disable the Batch Means method.");
        }
        this.batchesNumber = batchesNumber;
        this.parallel = parallel;
        this.latexTableResultsGeneration = latexTableResultsGeneration;
        this.seeds = parallel ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        Map<Object, Object> map = this.metricsMap = parallel ? Collections.synchronizedMap(new TreeMap()) : new TreeMap();
        if (this.isApplyBatchMeansMethod() || this.isApplyAntitheticVariatesTechnique()) {
            this.setSimulationRunsAndBatchesToEvenNumber();
        }
        if (this.isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches()) {
            this.setNumberOfSimulationRunsAsMultipleOfNumberOfBatches();
        }
        this.setup();
        this.experiments = IntStream.range(0, simulationRuns).mapToObj(this::createExperiment).collect(Collectors.toList());
    }

    protected abstract void setup();

    private void setSimulationRunsAndBatchesToEvenNumber() {
        if (this.getSimulationRuns() % 2 != 0) {
            ++this.simulationRuns;
        }
        if (this.getBatchesNumber() > 0 && this.getSimulationRuns() % this.getBatchesNumber() != 0) {
            this.setSimulationRunsAsMultipleOfBatchNumber();
        }
    }

    private void setNumberOfSimulationRunsAsMultipleOfNumberOfBatches() {
        this.simulationRuns = this.batchSizeCeil() * this.getBatchesNumber();
    }

    private boolean isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches() {
        return this.isApplyBatchMeansMethod() && this.getSimulationRuns() % this.getBatchesNumber() != 0;
    }

    public int batchSizeCeil() {
        return (int)Math.ceil((double)this.simulationRuns / (double)this.batchesNumber);
    }

    public boolean simulationRunsAndNumberOfBatchesAreCompatible() {
        boolean batchesGreaterThan1 = this.batchesNumber > 1;
        boolean numSimulationRunsGraterThanBatches = this.simulationRuns > this.batchesNumber;
        return batchesGreaterThan1 && numSimulationRunsGraterThanBatches;
    }

    public boolean isApplyBatchMeansMethod() {
        return this.simulationRunsAndNumberOfBatchesAreCompatible();
    }

    protected List<Double> computeBatchMeans(List<Double> samples) {
        if (!this.isApplyBatchMeansMethod()) {
            return samples;
        }
        ArrayList<Double> batchMeans = new ArrayList<Double>(this.getBatchesNumber());
        for (int i = 0; i < this.getBatchesNumber(); ++i) {
            batchMeans.add(this.getBatchAverage(samples, i));
        }
        System.out.printf("\tBatch Means Method applied. The number of samples was reduced to %d after computing the mean for each batch.%n", this.getBatchesNumber());
        return batchMeans;
    }

    private double getBatchAverage(List<Double> samples, int i) {
        int k = this.batchSizeCeil();
        return IntStream.range(0, k).mapToDouble(j -> (Double)samples.get(this.getBatchElementIndex(i, j))).average().orElse(0.0);
    }

    private int getBatchElementIndex(int i, int j) {
        int k = this.batchSizeCeil();
        return i * k + j;
    }

    public boolean isApplyAntitheticVariatesTechnique() {
        return this.applyAntitheticVariatesTechnique;
    }

    public int getSimulationRuns() {
        return this.simulationRuns;
    }

    private ExperimentRunner setSimulationRunsAsMultipleOfBatchNumber() {
        this.simulationRuns = this.getBatchesNumber() * (int)Math.ceil(this.getSimulationRuns() / this.getBatchesNumber());
        return this;
    }

    public int getBatchesNumber() {
        return this.batchesNumber;
    }

    public long getBaseSeed() {
        return this.baseSeed;
    }

    long getSeed(int experimentIndex) {
        return this.seeds.get(experimentIndex);
    }

    public <T extends StatisticalDistribution> T createRandomGen(int experimentIndex, Function<Long, T> randomGenCreator) {
        Objects.requireNonNull(randomGenCreator, "The Function to instantiate the Random Number Generator cannot be null.");
        if (this.seeds.isEmpty()) {
            throw new IllegalStateException("You have to create at least 1 SimulationExperiment before requesting a ExperimentRunner to create a pseudo random number generator (PRNG)!");
        }
        if (this.isToReuseSeedFromFirstHalfOfExperiments(experimentIndex)) {
            int expIndexFromFirstHalf = experimentIndex - this.halfSimulationRuns();
            StatisticalDistribution prng = (StatisticalDistribution)randomGenCreator.apply(this.getSeed(expIndexFromFirstHalf));
            prng.setApplyAntitheticVariates(true);
            return (T)prng;
        }
        return (T)((StatisticalDistribution)randomGenCreator.apply(this.getSeed(experimentIndex)));
    }

    public ContinuousDistribution createRandomGen(int experimentIndex) {
        return this.createRandomGen(experimentIndex, 0.0, 1.0);
    }

    public ContinuousDistribution createRandomGen(int experimentIndex, double minInclusive, double maxExclusive) {
        return this.createRandomGen(experimentIndex, seed -> new UniformDistr(minInclusive, maxExclusive, (long)seed));
    }

    public boolean isToReuseSeedFromFirstHalfOfExperiments(int currentExperimentIndex) {
        return this.isApplyAntitheticVariatesTechnique() && this.simulationRuns > 1 && currentExperimentIndex >= this.halfSimulationRuns();
    }

    void addSeed(long seed) {
        if (!this.seeds.contains(seed)) {
            this.seeds.add(seed);
        }
    }

    public int halfSimulationRuns() {
        return this.simulationRuns / 2;
    }

    public long getExperimentsExecutionTimeSecs() {
        return this.experimentsExecutionTimeSecs;
    }

    public long getExperimentsStartTimeSecs() {
        return this.experimentsStartTimeSecs;
    }

    @Override
    public void run() {
        String desc = this.description != null && !this.description.isEmpty() ? String.format(" - %s", this.description) : "";
        System.out.printf("Started %s at %s (real local time)%s%n", this.getClass().getSimpleName(), LocalTime.now(), desc);
        this.printSimulationParameters();
        Log.setLevel(Level.OFF);
        try {
            this.experimentsStartTimeSecs = Math.round((double)System.currentTimeMillis() / 1000.0);
            this.getStream(this.experiments).forEach(Experiment::run);
            System.out.println();
            this.experimentsExecutionTimeSecs = TimeUtil.elapsedSeconds(this.experimentsStartTimeSecs);
        }
        finally {
            Log.setLevel(Level.INFO);
        }
        System.out.printf("%nFinal simulation results for %d metrics in %d simulation runs -------------------%n", this.metricsMap.size(), this.simulationRuns);
        if (!this.simulationRunsAndNumberOfBatchesAreCompatible()) {
            System.out.println("Batch means method was not be applied because the number of simulation runs is not greater than the number of batches.");
        }
        this.computeAndPrintFinalResults();
        System.out.printf("%nExperiments for %d runs finished in %s!%n", this.simulationRuns, TimeUtil.secondsToStr(this.experimentsExecutionTimeSecs));
    }

    private void computeAndPrintFinalResults() {
        TreeMap<String, SummaryStatistics> statsMap = new TreeMap<String, SummaryStatistics>();
        this.metricsMap.entrySet().forEach(e -> statsMap.put((String)e.getKey(), this.computeAndPrintFinalResults((Map.Entry<String, List<Double>>)e)));
        this.buildLatexMetricsResultTable(statsMap);
    }

    private void buildLatexMetricsResultTable(Map<String, SummaryStatistics> statsMap) {
        if (!this.latexTableResultsGeneration) {
            return;
        }
        if (this.simulationRuns == 1) {
            System.out.println("Latex table with metrics' results is just built when the number of simulation runs is greater than 1.");
            return;
        }
        StringBuilder latex = this.startLatexTable();
        statsMap.forEach((metric, stats) -> this.latexRow(latex, (String)metric, (SummaryStatistics)stats));
        latex.append("  \\end{tabular}\n").append("\\end{table}\n");
        System.out.println();
        System.out.println(latex);
    }

    private void latexRow(StringBuilder latex, String metricName, SummaryStatistics stats) {
        String errorMargin = String.format("%.4f", this.confidenceErrorMargin(stats));
        String escapedMetricName = metricName.replaceAll("%", "\\%");
        latex.append(escapedMetricName).append(" & ").append(String.format("%.2f", stats.getMean())).append(" $\\pm$ & ").append(errorMargin).append(" & ").append(String.format("%.4f", stats.getStandardDeviation())).append("\\\\ \\hline\n");
    }

    private StringBuilder startLatexTable() {
        StringBuilder latex = new StringBuilder();
        latex.append("\\begin{table}[hbt]\n").append(String.format("  \\caption{%s}\n", this.description)).append(String.format("  \\label{%s}\n", this.resultsTableId)).append("  \\begin{tabular}{|l|rr|>{\\raggedleft\\arraybackslash}p{1.3cm}|}\n").append("      \\hline\n").append("      textbf{Metric} & \\multicolumn{2}{c|}{\\textbf{95\\% Confidence Interval}} & \\textbf{*Standard Deviation} \\\\ \\hline\n");
        return latex;
    }

    private Stream<Experiment> getStream(List<Experiment> experiments) {
        return this.parallel ? (Stream)experiments.stream().parallel() : experiments.stream();
    }

    private Experiment createExperiment(int i) {
        this.print((i + 1) % 100 == 0 ? String.format(". Run #%d%n", i + 1) : ".");
        this.setFirstExperimentCreated(i);
        T exp = this.createExperimentInternal(i);
        ((AbstractExperiment)exp).setVerbose(((AbstractExperiment)exp).isVerbose() && !this.parallel);
        return exp;
    }

    protected abstract T createExperimentInternal(int var1);

    protected SummaryStatistics computeAndPrintFinalResults(Map.Entry<String, List<Double>> metricEntry) {
        List<Double> metricValues = metricEntry.getValue();
        SummaryStatistics stats = this.computeFinalStatistics(metricValues);
        String valuesStr = metricValues.stream().map(v -> String.format("%.2f", v)).collect(Collectors.joining(", "));
        System.out.printf("# %s: %.2f (samples: %s)%n", metricEntry.getKey(), stats.getMean(), valuesStr);
        if (this.simulationRuns > 1) {
            this.showConfidenceInterval(stats);
        }
        return stats;
    }

    protected final SummaryStatistics computeFinalStatistics(List<Double> values) {
        SummaryStatistics stats = new SummaryStatistics();
        List<Double> adjustedValues = this.computeAntitheticMeans(this.computeBatchMeans(values));
        adjustedValues.forEach(arg_0 -> ((SummaryStatistics)stats).addValue(arg_0));
        return stats;
    }

    private void showConfidenceInterval(SummaryStatistics stats) {
        double intervalSize = this.confidenceErrorMargin(stats);
        double criticalValue = this.getConfidenceIntervalCriticalValue(stats.getN());
        System.out.printf("\tt-Distribution critical value for %d samples: %f%n", stats.getN(), criticalValue);
        double lower = stats.getMean() - intervalSize;
        double upper = stats.getMean() + intervalSize;
        System.out.printf("\t95%% Confidence Interval: %.6f \u2213 %.4f, that is [%.4f to %.4f]%n", stats.getMean(), intervalSize, lower, upper);
        System.out.printf("\tStandard Deviation: %.4f%n", stats.getStandardDeviation());
    }

    protected double confidenceErrorMargin(SummaryStatistics stats) {
        try {
            long samples = stats.getN();
            double criticalValue = this.getConfidenceIntervalCriticalValue(samples);
            return criticalValue * stats.getStandardDeviation() / Math.sqrt(samples);
        }
        catch (MathIllegalArgumentException e) {
            return Double.NaN;
        }
    }

    private double getConfidenceIntervalCriticalValue(long samples) {
        double freedomDegrees = samples - 1L;
        TDistribution tDist = new TDistribution(freedomDegrees);
        double significance = 0.050000000000000044;
        double criticalValue = tDist.inverseCumulativeProbability(0.975);
        return criticalValue;
    }

    protected final void addMetricValue(String metricName, double value) {
        List<Double> metricValues = this.getMetricValues(metricName);
        metricValues.add(value);
    }

    protected final List<Double> getMetricValues(String metricName) {
        return this.metricsMap.compute(metricName, (key, values) -> values == null ? new ArrayList(this.simulationRuns) : values);
    }

    protected List<Double> computeAntitheticMeans(List<Double> samples) {
        if (!this.isApplyAntitheticVariatesTechnique()) {
            return samples;
        }
        int half = samples.size() / 2;
        ArrayList<Double> antitheticMeans = new ArrayList<Double>(half);
        for (int i = 0; i < half; ++i) {
            antitheticMeans.add((samples.get(i) + samples.get(half + i)) / 2.0);
        }
        System.out.printf("\tAntithetic Variates Technique applied. The number of samples was reduced to the half (%d).%n", half);
        return antitheticMeans;
    }

    protected abstract void printSimulationParameters();

    public void setFirstExperimentCreated(int firstExperimentCreated) {
        if (this.firstExperimentCreated < 0) {
            this.firstExperimentCreated = firstExperimentCreated;
        }
    }

    public int getFirstExperimentCreated() {
        return this.firstExperimentCreated;
    }

    public ExperimentRunner setDescription(String description) {
        this.description = description;
        return this;
    }

    public ExperimentRunner setResultsTableId(String resultsTableId) {
        this.resultsTableId = resultsTableId;
        return this;
    }

    public ExperimentRunner enableLatexTableResultsGeneration() {
        this.latexTableResultsGeneration = true;
        return this;
    }
}

