/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostSuitability;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.schedulers.MipsShare;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmGroup;
import org.cloudsimplus.autoscaling.VerticalVmScaling;

public abstract class VmAllocationPolicyAbstract
implements VmAllocationPolicy {
    private BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction;
    private Datacenter datacenter;
    private int hostCountForParallelSearch;

    public VmAllocationPolicyAbstract() {
        this(null);
    }

    public VmAllocationPolicyAbstract(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        this.setDatacenter(Datacenter.NULL);
        this.setFindHostForVmFunction(findHostForVmFunction);
        this.hostCountForParallelSearch = 20000;
    }

    @Override
    public final <T extends Host> List<T> getHostList() {
        return this.datacenter.getHostList();
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public final void setDatacenter(Datacenter datacenter) {
        this.datacenter = Objects.requireNonNull(datacenter);
    }

    @Override
    public boolean scaleVmVertically(VerticalVmScaling scaling) {
        if (scaling.isVmUnderloaded()) {
            return this.downScaleVmVertically(scaling);
        }
        if (scaling.isVmOverloaded()) {
            return this.upScaleVmVertically(scaling);
        }
        return false;
    }

    private boolean upScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.upScaleVmNonCpuResource(scaling);
    }

    private boolean downScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.downScaleVmNonCpuResource(scaling);
    }

    private boolean scaleVmPesUpOrDown(VerticalVmScaling scaling) {
        double numberOfPesForScaling = scaling.getResourceAmountToScale();
        if (numberOfPesForScaling == 0.0) {
            return false;
        }
        if (scaling.isVmOverloaded() && this.isNotHostPesSuitableToUpScaleVm(scaling)) {
            this.showResourceIsUnavailable(scaling);
            return false;
        }
        Vm vm = scaling.getVm();
        vm.getHost().getVmScheduler().deallocatePesFromVm(vm);
        int signal = scaling.isVmUnderloaded() ? -1 : 1;
        vm.getProcessor().sumCapacity((long)numberOfPesForScaling * (long)signal);
        vm.getHost().getVmScheduler().allocatePesForVm(vm);
        return true;
    }

    private boolean isNotHostPesSuitableToUpScaleVm(VerticalVmScaling scaling) {
        Vm vm = scaling.getVm();
        long numberOfPesForScaling = (long)scaling.getResourceAmountToScale();
        MipsShare additionalVmMips = new MipsShare(numberOfPesForScaling, vm.getMips());
        return !vm.getHost().getVmScheduler().isSuitableForVm(vm, additionalVmMips);
    }

    private boolean isRequestingCpuScaling(VerticalVmScaling scaling) {
        return Processor.class.equals(scaling.getResourceClass());
    }

    private boolean upScaleVmNonCpuResource(VerticalVmScaling scaling) {
        double extraAmountToAllocate;
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable hostResource = scaling.getVm().getHost().getResource(resourceClass);
        if (!hostResource.isAmountAvailable(extraAmountToAllocate = scaling.getResourceAmountToScale())) {
            return false;
        }
        ResourceProvisioner provisioner = scaling.getVm().getHost().getProvisioner(resourceClass);
        ResourceManageable vmResource = scaling.getVm().getResource(resourceClass);
        double newTotalVmResource = (double)vmResource.getCapacity() + extraAmountToAllocate;
        if (!provisioner.allocateResourceForVm(scaling.getVm(), newTotalVmResource)) {
            this.showResourceIsUnavailable(scaling);
            return false;
        }
        LOGGER.info("{}: {}: {} more {} allocated to {}: new capacity is {}. Current resource usage is {}%", new Object[]{scaling.getVm().getSimulation().clockStr(), scaling.getClass().getSimpleName(), (long)extraAmountToAllocate, resourceClass.getSimpleName(), scaling.getVm(), vmResource.getCapacity(), vmResource.getPercentUtilization() * 100.0});
        return true;
    }

    private void showResourceIsUnavailable(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable hostResource = scaling.getVm().getHost().getResource(resourceClass);
        double extraAmountToAllocate = scaling.getResourceAmountToScale();
        LOGGER.warn("{}: {}: {} requested more {} of {} capacity but the {} has just {} of available {}", new Object[]{scaling.getVm().getSimulation().clockStr(), scaling.getClass().getSimpleName(), scaling.getVm(), (long)extraAmountToAllocate, resourceClass.getSimpleName(), scaling.getVm().getHost(), hostResource.getAvailableResource(), resourceClass.getSimpleName()});
    }

    private boolean downScaleVmNonCpuResource(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable vmResource = scaling.getVm().getResource(resourceClass);
        double amountToDeallocate = scaling.getResourceAmountToScale();
        ResourceProvisioner provisioner = scaling.getVm().getHost().getProvisioner(resourceClass);
        double newTotalVmResource = (double)vmResource.getCapacity() - amountToDeallocate;
        if (!provisioner.allocateResourceForVm(scaling.getVm(), newTotalVmResource)) {
            LOGGER.error("{}: {}: {} requested to reduce {} capacity by {} but an unexpected error occurred and the resource was not resized", new Object[]{scaling.getVm().getSimulation().clockStr(), scaling.getClass().getSimpleName(), scaling.getVm(), resourceClass.getSimpleName(), (long)amountToDeallocate});
            return false;
        }
        LOGGER.info("{}: {}: {} {} deallocated from {}: new capacity is {}. Current resource usage is {}%", new Object[]{scaling.getVm().getSimulation().clockStr(), scaling.getClass().getSimpleName(), (long)amountToDeallocate, resourceClass.getSimpleName(), scaling.getVm(), vmResource.getCapacity(), vmResource.getPercentUtilization() * 100.0});
        return true;
    }

    @Override
    public HostSuitability allocateHostForVm(Vm vm) {
        if (this.getHostList().isEmpty()) {
            LOGGER.error("{}: {}: {} could not be allocated because there isn't any Host for Datacenter {}", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, this.getDatacenter().getId()});
            return new HostSuitability("Datacenter has no host.");
        }
        if (vm.isCreated()) {
            return new HostSuitability("VM is already created");
        }
        Optional<Host> optional = this.findHostForVm(vm);
        if (optional.filter(Host::isActive).isPresent()) {
            return this.allocateHostForVm(vm, optional.get());
        }
        LOGGER.warn("{}: {}: No suitable host found for {} in {}", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, this.datacenter});
        return new HostSuitability("No suitable host found");
    }

    @Override
    public <T extends Vm> List<T> allocateHostForVm(Collection<T> vmCollection) {
        Objects.requireNonNull(vmCollection, "The list of VMs to allocate a host to cannot be null");
        return vmCollection.stream().filter(vm -> !this.allocateHostForVm((Vm)vm).fully()).collect(Collectors.toList());
    }

    @Override
    public HostSuitability allocateHostForVm(Vm vm, Host host) {
        if (vm instanceof VmGroup) {
            return this.createVmsFromGroup((VmGroup)vm, host);
        }
        return this.createVm(vm, host);
    }

    private HostSuitability createVmsFromGroup(VmGroup vmGroup, Host host) {
        int createdVms = 0;
        HostSuitability hostSuitabilityForVmGroup = new HostSuitability();
        for (Vm vm : vmGroup.getVmList()) {
            HostSuitability suitability = this.createVm(vm, host);
            hostSuitabilityForVmGroup.setSuitability(suitability);
            int i = Conversion.boolToInt(suitability.fully());
            createdVms += i;
        }
        vmGroup.setCreated(createdVms > 0);
        if (vmGroup.isCreated()) {
            vmGroup.setHost(host);
        }
        return hostSuitabilityForVmGroup;
    }

    private HostSuitability createVm(Vm vm, Host host) {
        HostSuitability suitability = host.createVm(vm);
        if (suitability.fully()) {
            LOGGER.info("{}: {}: {} has been allocated to {}", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, host});
        } else {
            LOGGER.error("{}: {} Creation of {} on {} failed due to {}.", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, host, suitability});
        }
        return suitability;
    }

    @Override
    public void deallocateHostForVm(Vm vm) {
        vm.getHost().destroyVm(vm);
    }

    @Override
    public final void setFindHostForVmFunction(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        this.findHostForVmFunction = findHostForVmFunction;
    }

    @Override
    public final Optional<Host> findHostForVm(Vm vm) {
        Optional<Host> optional = this.findHostForVmFunction == null ? this.defaultFindHostForVm(vm) : this.findHostForVmFunction.apply(this, vm);
        return optional.map(host -> host.setActive(true));
    }

    protected abstract Optional<Host> defaultFindHostForVm(Vm var1);

    @Override
    public Map<Vm, Host> getOptimizedAllocationMap(List<? extends Vm> vmList) {
        return Collections.emptyMap();
    }

    @Override
    public int getHostCountForParallelSearch() {
        return this.hostCountForParallelSearch;
    }

    @Override
    public void setHostCountForParallelSearch(int hostCountForParallelSearch) {
        this.hostCountForParallelSearch = hostCountForParallelSearch;
    }

    @Override
    public boolean isVmMigrationSupported() {
        return false;
    }
}

