/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.migration;

import java.util.Objects;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigration;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigrationAbstract;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigrationDynamicUpperThreshold;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;

public abstract class VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit
extends VmAllocationPolicyMigrationAbstract
implements VmAllocationPolicyMigrationDynamicUpperThreshold {
    private double safetyParameter;
    private VmAllocationPolicyMigration fallbackVmAllocationPolicy;

    public VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit(VmSelectionPolicy vmSelectionPolicy) {
        this(vmSelectionPolicy, 0.0, VmAllocationPolicyMigration.NULL);
    }

    public VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit(VmSelectionPolicy vmSelectionPolicy, double safetyParameter, VmAllocationPolicyMigration fallbackVmAllocationPolicy) {
        super(vmSelectionPolicy);
        this.setSafetyParameter(safetyParameter);
        this.setFallbackVmAllocationPolicy(fallbackVmAllocationPolicy);
    }

    @Override
    public boolean isHostOverloaded(Host host) {
        if (this.getOverUtilizationThreshold(host) == Double.MAX_VALUE) {
            return this.getFallbackVmAllocationPolicy().isHostOverloaded(host);
        }
        return super.isHostOverloaded(host);
    }

    @Override
    public double getOverUtilizationThreshold(Host host) {
        try {
            return 1.0 - this.getSafetyParameter() * this.computeHostUtilizationMeasure(host);
        }
        catch (IllegalStateException e) {
            return Double.MAX_VALUE;
        }
    }

    protected final void setSafetyParameter(double safetyParameter) {
        if (safetyParameter < 0.0) {
            throw new IllegalArgumentException("The safety parameter must be a positive value. It is a percentage value in scale from 0 to 1 where, for instance, 1 means 100% and 1.5 means 150%.");
        }
        this.safetyParameter = safetyParameter;
    }

    @Override
    public double getSafetyParameter() {
        return this.safetyParameter;
    }

    @Override
    public final void setFallbackVmAllocationPolicy(VmAllocationPolicyMigration fallbackPolicy) {
        this.fallbackVmAllocationPolicy = Objects.requireNonNull(fallbackPolicy);
    }

    @Override
    public VmAllocationPolicyMigration getFallbackVmAllocationPolicy() {
        return this.fallbackVmAllocationPolicy;
    }
}

