/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.function.Consumer;
import org.cloudbus.cloudsim.core.Simulation;

class CircularTimeQueue {
    private final double[] queue;
    private final Simulation simulation;
    private double lastClockTickUpdate;

    public CircularTimeQueue(Simulation simulation) {
        this.simulation = simulation;
        this.lastClockTickUpdate = simulation.getMinTimeBetweenEvents();
        this.queue = new double[]{this.lastClockTickUpdate, this.lastClockTickUpdate};
    }

    public void tryToUpdateListeners(Consumer<Double> notifyClockTickListeners) {
        if (!this.isTimeToUpdateClockTickListeners()) {
            return;
        }
        this.addCurrentTime();
        if (this.isPreviousTimeOlder()) {
            this.lastClockTickUpdate = this.previous();
            notifyClockTickListeners.accept(this.lastClockTickUpdate);
        }
    }

    private void addCurrentTime() {
        this.queue[0] = this.queue[1];
        this.queue[1] = this.simulation.clock();
    }

    private boolean isPreviousTimeOlder() {
        return this.queue[0] < this.queue[1];
    }

    private double previous() {
        return this.queue[0];
    }

    private boolean isTimeToUpdateClockTickListeners() {
        return this.simulation.clock() > this.lastClockTickUpdate;
    }
}

