/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.Objects;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.core.CustomerEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.UniquelyIdentifiable;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.util.TimeUtil;

public abstract class CustomerEntityAbstract
implements CustomerEntity {
    private long id;
    private double arrivedTime;
    private double creationRequestTime;
    private DatacenterBroker broker;
    private Datacenter lastTriedDatacenter = Datacenter.NULL;

    protected CustomerEntityAbstract() {
    }

    @Override
    public final void setBroker(DatacenterBroker broker) {
        this.broker = Objects.requireNonNull(broker);
    }

    @Override
    public DatacenterBroker getBroker() {
        return this.broker;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public final void setId(long id) {
        this.id = id;
    }

    @Override
    public String getUid() {
        return UniquelyIdentifiable.getUid(this.broker.getId(), this.id);
    }

    @Override
    public double getArrivedTime() {
        return this.arrivedTime;
    }

    @Override
    public CustomerEntity setArrivedTime(double time) {
        this.arrivedTime = TimeUtil.validateTime("Arrived time", time);
        return this;
    }

    @Override
    public double getCreationRequestTime() {
        return this.creationRequestTime;
    }

    public CustomerEntity setCreationRequestTime() {
        this.setCreationRequestTime(this.getSimulation().clock() + this.getSubmissionDelay());
        return this;
    }

    public CustomerEntity setCreationRequestTime(double time) {
        this.creationRequestTime = TimeUtil.validateTime("Creation request time", time);
        return this;
    }

    @Override
    public double getWaitTime() {
        return this.creationRequestTime - this.arrivedTime;
    }

    @Override
    public Simulation getSimulation() {
        return this.broker.getSimulation();
    }

    public final int hashCode() {
        int result = this.broker.hashCode();
        result = 31 * result + Long.hashCode(this.id);
        return result;
    }

    @Override
    public void setLastTriedDatacenter(Datacenter lastTriedDatacenter) {
        this.lastTriedDatacenter = lastTriedDatacenter;
    }

    @Override
    public Datacenter getLastTriedDatacenter() {
        return this.lastTriedDatacenter;
    }
}

