/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.distributions;

import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.StatisticalDistribution;

public class WeibullDistr
extends WeibullDistribution
implements ContinuousDistribution {
    private boolean applyAntitheticVariates;
    private long seed;

    public WeibullDistr(double alpha, double beta) {
        this(alpha, beta, StatisticalDistribution.defaultSeed());
    }

    public WeibullDistr(double alpha, double beta, long seed) {
        this(alpha, beta, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public WeibullDistr(double alpha, double beta, long seed, RandomGenerator rng) {
        super(rng, alpha, beta);
        if (seed < 0L) {
            throw new IllegalArgumentException("Seed cannot be negative");
        }
        this.seed = seed;
    }

    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public WeibullDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return super.sample();
    }
}

