/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.power.PowerMeasurement;
import org.cloudbus.cloudsim.power.models.PowerModel;
import org.cloudbus.cloudsim.power.models.PowerModelDatacenter;

public class PowerModelDatacenterSimple
extends PowerModelDatacenter {
    private double powerUsageEffectiveness = 1.0;

    public PowerModelDatacenterSimple(Datacenter datacenter) {
        this.setDatacenter(datacenter);
    }

    @Override
    public PowerMeasurement getPowerMeasurement() {
        PowerMeasurement measurement = this.getDatacenter().getHostList().stream().map(Host::getPowerModel).map(PowerModel::getPowerMeasurement).reduce(PowerMeasurement::add).orElse(new PowerMeasurement());
        return measurement.multiply(this.powerUsageEffectiveness);
    }

    public double getPowerUsageEffectiveness() {
        return this.powerUsageEffectiveness;
    }

    public void setPowerUsageEffectiveness(double powerUsageEffectiveness) {
        if (powerUsageEffectiveness < 0.0 || powerUsageEffectiveness > 1.0) {
            throw new IllegalArgumentException("powerUsageEffectiveness must be between [0 and 1].");
        }
        this.powerUsageEffectiveness = powerUsageEffectiveness;
    }
}

