/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import java.util.Objects;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.power.models.PowerModel;
import org.cloudbus.cloudsim.power.models.PowerModelHostNull;

public abstract class PowerModelHost
implements PowerModel {
    public static final PowerModelHost NULL = new PowerModelHostNull();
    private Host host;
    private double startupDelay;
    private double shutDownDelay;
    private double startupPower;
    private double totalStartupPower;
    private double shutDownPower;
    private double totalShutDownPower;
    private double totalStartupTime;
    private double totalShutDownTime;
    private int totalStartups;

    protected static double validatePower(double power, String fieldName) {
        PowerModelHost.positive(power, fieldName);
        if (power < 1.0) {
            throw new IllegalArgumentException(fieldName + " must be in watts. A value smaller than 1 may indicate you're trying to give a percentage value instead.");
        }
        return power;
    }

    protected static double positive(double value, String fieldName) {
        if (value < 0.0) {
            throw new IllegalArgumentException(fieldName + " cannot be negative.");
        }
        return value;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = Objects.requireNonNull(host);
    }

    public abstract double getPower(double var1) throws IllegalArgumentException;

    public double getStartupDelay() {
        return this.startupDelay;
    }

    public PowerModelHost setStartupDelay(double delay) {
        this.startupDelay = PowerModelHost.positive(delay, "Delay");
        return this;
    }

    public double getShutDownDelay() {
        return this.shutDownDelay;
    }

    public PowerModelHost setShutDownDelay(double delay) {
        this.shutDownDelay = PowerModelHost.positive(delay, "Delay");
        return this;
    }

    public double getStartupPower() {
        return this.startupPower;
    }

    public PowerModelHost setStartupPower(double power) {
        this.startupPower = PowerModelHost.validatePower(power, "Power");
        return this;
    }

    public double getShutDownPower() {
        return this.shutDownPower;
    }

    public PowerModelHost setShutDownPower(double power) {
        this.shutDownPower = PowerModelHost.validatePower(power, "Power");
        return this;
    }

    public double getTotalStartupPower() {
        return this.totalStartupPower;
    }

    public void addStartupTotals() {
        this.totalStartupPower += this.startupPower;
        this.totalStartupTime += this.startupDelay;
        ++this.totalStartups;
    }

    public double getTotalShutDownPower() {
        return this.totalShutDownPower;
    }

    public void addShutDownTotals() {
        this.totalShutDownPower += this.shutDownPower;
        this.totalShutDownTime += this.shutDownDelay;
    }

    public int getTotalStartups() {
        return this.totalStartups;
    }

    public double getTotalStartupTime() {
        return this.totalStartupTime;
    }

    public double getTotalShutDownTime() {
        return this.totalShutDownTime;
    }
}

