/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.provisioners;

import java.util.Objects;
import java.util.function.Function;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;

public abstract class ResourceProvisionerAbstract
implements ResourceProvisioner {
    private ResourceManageable pmResource;
    private Function<Vm, ResourceManageable> vmResourceFunction;

    protected ResourceProvisionerAbstract() {
        this(ResourceManageable.NULL, vm -> ResourceManageable.NULL);
    }

    public ResourceProvisionerAbstract(ResourceManageable pmResource, Function<Vm, ResourceManageable> vmResourceFunction) {
        this.setResources(pmResource, vmResourceFunction);
    }

    @Override
    public long getAllocatedResourceForVm(Vm vm) {
        return this.vmResourceFunction.apply(vm).getAllocatedResource();
    }

    @Override
    public ResourceManageable getPmResource() {
        return this.pmResource;
    }

    @Override
    public final void setResources(ResourceManageable pmResource, Function<Vm, ResourceManageable> vmResourceFunction) {
        this.pmResource = Objects.requireNonNull(pmResource);
        this.vmResourceFunction = Objects.requireNonNull(vmResourceFunction);
    }

    @Override
    public long getCapacity() {
        return this.pmResource.getCapacity();
    }

    @Override
    public long getTotalAllocatedResource() {
        return this.pmResource.getAllocatedResource();
    }

    @Override
    public long getAvailableResource() {
        return this.pmResource.getAvailableResource();
    }

    protected Function<Vm, ResourceManageable> getVmResourceFunction() {
        return this.vmResourceFunction;
    }
}

