/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import org.apache.commons.lang3.StringUtils;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudbus.cloudsim.resources.SimpleStorage;
import org.cloudbus.cloudsim.util.Conversion;

public class HarddriveStorage
implements FileStorage {
    private final SimpleStorage storage;
    private final String name;
    private ContinuousDistribution gen;
    private double maxTransferRate;
    private double latency;
    private double avgSeekTime;

    public HarddriveStorage(String name, long capacity) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Storage name cannot be empty.");
        }
        this.name = name;
        this.storage = new SimpleStorage(capacity);
        this.init();
    }

    public HarddriveStorage(long capacity) throws IllegalArgumentException {
        this("HarddriveStorage", capacity);
    }

    private void init() {
        this.setLatency(0.00417);
        this.setAvgSeekTime(0.009);
        this.setMaxTransferRate(1064.0);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public double getLatency() {
        return this.latency;
    }

    @Override
    public FileStorage setLatency(double latency) {
        if (latency < 0.0) {
            throw new IllegalArgumentException("Latency must be greater than zero.");
        }
        this.latency = latency;
        return this;
    }

    @Override
    public double getMaxTransferRate() {
        return this.maxTransferRate;
    }

    @Override
    public FileStorage setMaxTransferRate(double maxTransferRate) {
        if (maxTransferRate <= 0.0) {
            throw new IllegalArgumentException("Max transfer rate must be greater than zero.");
        }
        this.maxTransferRate = maxTransferRate;
        return this;
    }

    public FileStorage setAvgSeekTime(double seekTime) {
        return this.setAvgSeekTime(seekTime, null);
    }

    public FileStorage setAvgSeekTime(double seekTime, ContinuousDistribution gen) {
        if (seekTime < 0.0) {
            throw new IllegalArgumentException("Seek time cannot be negative.");
        }
        this.avgSeekTime = seekTime;
        this.gen = gen;
        return this;
    }

    public double getAvgSeekTime() {
        return this.avgSeekTime;
    }

    public double getSeekTime(int fileSize) {
        double result = 0.0;
        if (this.gen != null) {
            result += this.gen.sample();
        }
        if (fileSize > 0 && this.storage.getCapacity() != 0L) {
            result += (double)fileSize / (double)this.storage.getCapacity();
        }
        return result;
    }

    @Override
    public double getTransferTime(int fileSize) {
        return this.getTransferTime(fileSize, this.getMaxTransferRate()) + this.getLatency();
    }

    protected final double getTransferTime(int fileSize, double speed) {
        return Conversion.bytesToBits(fileSize) / speed;
    }

    @Override
    public long getCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public long getAvailableResource() {
        return this.storage.getAvailableResource();
    }

    @Override
    public long getAllocatedResource() {
        return this.storage.getAllocatedResource();
    }

    @Override
    public boolean isAmountAvailable(long amountToCheck) {
        return this.storage.isAmountAvailable(amountToCheck);
    }

    @Override
    public boolean isAmountAvailable(double amountToCheck) {
        return this.isAmountAvailable((long)amountToCheck);
    }

    @Override
    public boolean isFull() {
        return this.storage.isFull();
    }

    public SimpleStorage getStorage() {
        return this.storage;
    }

    @Override
    public String getUnit() {
        return this.storage.getUnit();
    }
}

