/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.MipsShare;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmSimple;

public abstract class VmSchedulerAbstract
implements VmScheduler {
    public static final double DEFAULT_VM_MIGRATION_CPU_OVERHEAD = 0.1;
    private Host host;
    private final double vmMigrationCpuOverhead;

    public VmSchedulerAbstract(double vmMigrationCpuOverhead) {
        if (vmMigrationCpuOverhead < 0.0 || vmMigrationCpuOverhead >= 1.0) {
            throw new IllegalArgumentException("vmMigrationCpuOverhead must be a percentage value between [0 and 1[");
        }
        this.setHost(Host.NULL);
        this.vmMigrationCpuOverhead = vmMigrationCpuOverhead;
    }

    @Override
    public final boolean isSuitableForVm(Vm vm) {
        return this.isSuitableForVm(vm, vm.getCurrentRequestedMips());
    }

    @Override
    public final boolean isSuitableForVm(Vm vm, MipsShare requestedMips) {
        if (requestedMips.isEmpty()) {
            LOGGER.warn("{}: {}: It was requested an empty list of PEs for {} in {}", new Object[]{this.getHost().getSimulation().clockStr(), this.getClass().getSimpleName(), vm, this.host});
            return false;
        }
        if (this.getHost().isFailed()) {
            return false;
        }
        return this.isSuitableForVmInternal(vm, requestedMips);
    }

    protected abstract boolean isSuitableForVmInternal(Vm var1, MipsShare var2);

    @Override
    public final boolean allocatePesForVm(Vm vm) {
        return this.allocatePesForVm(vm, new MipsShare(vm.getNumberOfPes(), vm.getMips()));
    }

    @Override
    public final boolean allocatePesForVm(Vm vm, MipsShare requestedMips) {
        if (!vm.isInMigration() && this.host.getVmsMigratingOut().contains(vm)) {
            this.host.removeVmMigratingOut(vm);
        }
        ((VmSimple)vm).setRequestedMips(new MipsShare(requestedMips));
        if (this.allocatePesForVmInternal(vm, requestedMips)) {
            this.updateStatusOfHostPesUsedByVm(vm, this.getHost().getFreePeList(), Pe.Status.BUSY);
            return true;
        }
        return false;
    }

    private void updateStatusOfHostPesUsedByVm(Vm vm, List<Pe> peList, Pe.Status newStatus) {
        this.updateStatusOfHostPesUsedByVm(peList, newStatus, vm.getNumberOfPes());
    }

    private void updateStatusOfHostPesUsedByVm(List<Pe> peList, Pe.Status newStatus, long vPesNumber) {
        if (vPesNumber <= 0L) {
            return;
        }
        List<Pe> selectedPes = peList.stream().limit(vPesNumber).collect(Collectors.toList());
        ((HostSimple)this.host).setPeStatus(selectedPes, newStatus);
    }

    protected abstract boolean allocatePesForVmInternal(Vm var1, MipsShare var2);

    @Override
    public void deallocatePesFromVm(Vm vm) {
        this.deallocatePesFromVm(vm, (int)vm.getNumberOfPes());
    }

    @Override
    public void deallocatePesFromVm(Vm vm, int pesToRemove) {
        if (pesToRemove <= 0 || vm.getNumberOfPes() == 0L) {
            return;
        }
        long removedPes = this.deallocatePesFromVmInternal(vm, pesToRemove);
        this.updateHostUsedPesToFree(removedPes);
    }

    private void updateHostUsedPesToFree(long removedPes) {
        List<Pe> busyPeList = this.host.getBusyPeList();
        this.updateStatusOfHostPesUsedByVm(busyPeList, Pe.Status.FREE, removedPes);
    }

    protected final long removePesFromVm(Vm vm, MipsShare mipsShare, long pesToRemove) {
        return mipsShare.remove(Math.min(vm.getNumberOfPes(), pesToRemove));
    }

    protected abstract long deallocatePesFromVmInternal(Vm var1, int var2);

    @Override
    public MipsShare getAllocatedMips(Vm vm) {
        MipsShare mipsShare = ((VmSimple)vm).getAllocatedMips();
        return this.host.getVmsMigratingOut().contains(vm) ? this.getMipsShareRequestedReduced(vm, mipsShare) : mipsShare;
    }

    protected MipsShare getMipsShareRequestedReduced(Vm vm, MipsShare mipsShareRequested) {
        double peMips = this.getPeCapacity();
        long requestedPes = mipsShareRequested.pes();
        double requestedMips = mipsShareRequested.mips();
        return new MipsShare(requestedPes, Math.min(requestedMips, peMips) * this.percentOfMipsToRequest(vm));
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.getAllocatedMips(vm).totalMips();
    }

    public long getPeCapacity() {
        return this.getWorkingPeList().isEmpty() ? 0L : this.getWorkingPeList().get(0).getCapacity();
    }

    public final List<Pe> getWorkingPeList() {
        return this.host.getWorkingPeList();
    }

    @Override
    public MipsShare getRequestedMips(Vm vm) {
        return ((VmSimple)vm).getRequestedMips();
    }

    @Override
    public double getTotalAvailableMips() {
        Stream stream = Stream.concat(this.host.getVmList().stream(), this.host.getVmsMigratingIn().stream());
        double allocatedMips = stream.map(vm -> (VmSimple)vm).mapToDouble(this::actualVmTotalRequestedMips).sum();
        return this.host.getTotalMipsCapacity() - allocatedMips;
    }

    private double actualVmTotalRequestedMips(VmSimple vm) {
        double totalVmRequestedMips = vm.getAllocatedMips().totalMips();
        return totalVmRequestedMips / this.percentOfMipsToRequest(vm);
    }

    protected double percentOfMipsToRequest(Vm vm) {
        if (this.host.getVmsMigratingIn().contains(vm)) {
            return this.vmMigrationCpuOverhead;
        }
        if (this.host.getVmsMigratingOut().contains(vm)) {
            return this.getMaxCpuUsagePercentDuringOutMigration();
        }
        return 1.0;
    }

    @Override
    public double getMaxCpuUsagePercentDuringOutMigration() {
        return 1.0 - this.vmMigrationCpuOverhead;
    }

    @Override
    public double getVmMigrationCpuOverhead() {
        return this.vmMigrationCpuOverhead;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public final VmScheduler setHost(Host host) {
        if (this.isOtherHostAssigned(Objects.requireNonNull(host))) {
            throw new IllegalStateException("VmScheduler already has a Host assigned to it. Each Host must have its own VmScheduler instance.");
        }
        this.host = host;
        return this;
    }

    private boolean isOtherHostAssigned(Host host) {
        return this.host != null && this.host != Host.NULL && host != this.host;
    }
}

