/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public final class MathUtil {
    private MathUtil() {
    }

    public static double sum(List<? extends Number> list) {
        double sum = 0.0;
        for (Number number : list) {
            sum += number.doubleValue();
        }
        return sum;
    }

    public static double median(Collection<Double> list) {
        return MathUtil.getStatistics(list).getPercentile(50.0);
    }

    public static double median(double ... list) {
        return MathUtil.getStatistics(list).getPercentile(50.0);
    }

    public static DescriptiveStatistics getStatistics(Collection<Double> list) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        list.forEach(arg_0 -> ((DescriptiveStatistics)stats).addValue(arg_0));
        return stats;
    }

    public static DescriptiveStatistics getStatistics(double ... list) {
        return new DescriptiveStatistics(list);
    }

    public static double mean(List<Double> list) {
        if (list.isEmpty()) {
            return 0.0;
        }
        return MathUtil.sum(list) / (double)list.size();
    }

    public static double variance(List<Double> list) {
        long count = 0L;
        double mean = MathUtil.mean(list);
        double deltaSum = 0.0;
        for (double x : list) {
            double delta = x - mean;
            deltaSum += delta * (x - (mean += delta / (double)(++count)));
        }
        return deltaSum / (double)(count - 1L);
    }

    public static double stDev(List<Double> list) {
        return Math.sqrt(MathUtil.variance(list));
    }

    public static double mad(double ... data) {
        if (data.length == 0) {
            return 0.0;
        }
        double median = MathUtil.median(data);
        double[] deviationSum = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            deviationSum[i] = Math.abs(median - data[i]);
        }
        return MathUtil.median(deviationSum);
    }

    public static double iqr(double ... data) {
        Arrays.sort(data);
        int quartile1 = (int)Math.round(0.25 * (double)(data.length + 1)) - 1;
        int quartile3 = (int)Math.round(0.75 * (double)(data.length + 1)) - 1;
        return data[quartile3] - data[quartile1];
    }

    public static int countNonZeroBeginning(double ... data) {
        int i = data.length - 1;
        while (i >= 0 && data[i--] == 0.0) {
        }
        return i + 2;
    }

    public static double[] getLoessParameterEstimates(double ... y) {
        double[] x = MathUtil.createIndependentArray(y.length);
        return MathUtil.createWeightedLinearRegression(x, y, MathUtil.getTricubeWeights(y.length)).regress().getParameterEstimates();
    }

    private static double[] createIndependentArray(int length) {
        double[] x = new double[length];
        for (int i = 0; i < length; ++i) {
            x[i] = i + 1;
        }
        return x;
    }

    public static SimpleRegression createLinearRegression(double[] x, double[] y) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData(x[i], y[i]);
        }
        return regression;
    }

    public static OLSMultipleLinearRegression createLinearRegression(double[][] x, double[] y) {
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.newSampleData(y, x);
        return regression;
    }

    private static SimpleRegression createWeightedLinearRegression(double[] x, double[] y, double[] weights) {
        double[] weightedX = new double[x.length];
        double[] weightedY = new double[y.length];
        long numZeroWeights = Arrays.stream(weights).filter(weight -> weight <= 0.0).count();
        for (int i = 0; i < x.length; ++i) {
            if ((double)numZeroWeights >= 0.4 * (double)weights.length) {
                weightedX[i] = Math.sqrt(weights[i]) * x[i];
                weightedY[i] = Math.sqrt(weights[i]) * y[i];
                continue;
            }
            weightedX[i] = x[i];
            weightedY[i] = y[i];
        }
        return MathUtil.createLinearRegression(weightedX, weightedY);
    }

    public static double[] getRobustLoessParameterEstimates(double ... y) {
        double[] x = MathUtil.createIndependentArray(y.length);
        SimpleRegression tricubeRegression = MathUtil.createWeightedLinearRegression(x, y, MathUtil.getTricubeWeights(y.length));
        double[] residuals = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            residuals[i] = y[i] - tricubeRegression.predict(x[i]);
        }
        SimpleRegression tricubeBySqrRegression = MathUtil.createWeightedLinearRegression(x, y, MathUtil.getTricubeBisquareWeights(residuals));
        double[] estimates = tricubeBySqrRegression.regress().getParameterEstimates();
        if (Double.isNaN(estimates[0]) || Double.isNaN(estimates[1])) {
            return tricubeRegression.regress().getParameterEstimates();
        }
        return estimates;
    }

    public static double[] getTricubeWeights(int weightsNumber) {
        double[] weights = new double[weightsNumber];
        double top = weightsNumber - 1;
        for (int i = 2; i < weightsNumber; ++i) {
            double k = Math.pow(1.0 - Math.pow((top - (double)i) / top, 3.0), 3.0);
            weights[i] = k > 0.0 ? 1.0 / k : Double.MAX_VALUE;
        }
        weights[0] = weights[1] = weights[2];
        return weights;
    }

    public static double[] getTricubeBisquareWeights(double ... residuals) {
        double[] weights = MathUtil.getTricubeWeights(residuals.length);
        double[] weights2 = new double[residuals.length];
        double s6 = MathUtil.median(MathUtil.abs(residuals)) * 6.0;
        for (int i = 2; i < residuals.length; ++i) {
            double k = Math.pow(1.0 - Math.pow(residuals[i] / s6, 2.0), 2.0);
            weights2[i] = k > 0.0 ? 1.0 / k * weights[i] : Double.MAX_VALUE;
        }
        weights2[0] = weights2[1] = weights2[2];
        return weights2;
    }

    public static double[] abs(double ... data) {
        double[] result = new double[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.abs(data[i]);
        }
        return result;
    }

    public static int doubleToInt(double value) {
        return (int)(value < 0.0 ? Math.floor(value) : Math.ceil(value));
    }

    public static int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean same(double first, double second) {
        return MathUtil.same(first, second, 0.01);
    }

    public static boolean same(double first, double second, double precisionError) {
        return Math.abs(first - second) <= precisionError;
    }

    public static List<Double> correlationCoefficients(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        LinkedList<Double> correlationCoefficients = new LinkedList<Double>();
        for (int i = 0; i < rows; ++i) {
            double[][] x = new double[rows - 1][cols];
            int k = 0;
            for (int j = 0; j < rows; ++j) {
                if (j == i) continue;
                x[k++] = data[j];
            }
            double[][] xT = new Array2DRowRealMatrix(x).transpose().getData();
            correlationCoefficients.add(MathUtil.createLinearRegression(xT, data[i]).calculateRSquared());
        }
        return correlationCoefficients;
    }

    public static double percent(double partial, double total) {
        return partial / total * 100.0;
    }

    public static long positive(long first, long second) {
        return first > 0L ? first : second;
    }

    public static double positive(double first, double second) {
        return first > 0.0 ? first : second;
    }
}

