/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletSimple;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudbus.cloudsim.util.TraceReaderAbstract;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelFull;

public final class SwfWorkloadFileReader
extends TraceReaderAbstract {
    private static final int JOB_NUM_INDEX = 0;
    private static final int SUBMIT_TIME_INDEX = 1;
    private static final int RUN_TIME_INDEX = 3;
    private static final int NUM_PROC_INDEX = 4;
    private static final int REQ_NUM_PROC_INDEX = 7;
    private static final int REQ_RUN_TIME_INDEX = 8;
    private static final int USER_ID_INDEX = 11;
    private static final int GROUP_ID_INDEX = 12;
    private static final int FIELD_COUNT = 18;
    private static final int IRRELEVANT = -1;
    private int mips;
    private final List<Cloudlet> cloudlets;
    private Predicate<Cloudlet> predicate;

    public static SwfWorkloadFileReader getInstance(String fileName, int mips) {
        InputStream reader = ResourceLoader.newInputStream(fileName, SwfWorkloadFileReader.class);
        return new SwfWorkloadFileReader(fileName, reader, mips);
    }

    public SwfWorkloadFileReader(String filePath, int mips) throws IOException {
        this(filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), mips);
    }

    private SwfWorkloadFileReader(String filePath, InputStream reader, int mips) {
        super(filePath, reader);
        this.setMips(mips);
        this.cloudlets = new ArrayList<Cloudlet>();
        this.predicate = cloudlet -> true;
    }

    public List<Cloudlet> generateWorkload() {
        if (this.cloudlets.isEmpty()) {
            this.readFile(this::createCloudletFromTraceLine);
        }
        return this.cloudlets;
    }

    public SwfWorkloadFileReader setPredicate(Predicate<Cloudlet> predicate) {
        this.predicate = predicate;
        return this;
    }

    private boolean createCloudletFromTraceLine(String[] parsedLineArray) {
        if (parsedLineArray.length < 18) {
            return false;
        }
        int id = Integer.parseInt(parsedLineArray[0].trim());
        int runTime = Math.max(Integer.parseInt(parsedLineArray[3].trim()), 1);
        int maxNumProc = Math.max(Integer.parseInt(parsedLineArray[7].trim()), Integer.parseInt(parsedLineArray[4].trim()));
        int numProc = Math.max(maxNumProc, 1);
        Cloudlet cloudlet = this.createCloudlet(id, runTime, numProc);
        long submitTime = Long.parseLong(parsedLineArray[1].trim());
        cloudlet.setSubmissionDelay(submitTime);
        if (this.predicate.test(cloudlet)) {
            this.cloudlets.add(cloudlet);
            return true;
        }
        return false;
    }

    private Cloudlet createCloudlet(int id, int runTime, int numProc) {
        int len = runTime * this.mips;
        UtilizationModelFull utilizationModel = new UtilizationModelFull();
        return new CloudletSimple((long)id, (long)len, numProc).setFileSize(1500L).setOutputSize(1500L).setUtilizationModel(utilizationModel);
    }

    public int getMips() {
        return this.mips;
    }

    public SwfWorkloadFileReader setMips(int mips) {
        if (mips <= 0) {
            throw new IllegalArgumentException("MIPS must be greater than 0.");
        }
        this.mips = mips;
        return this;
    }
}

