/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.provisioners.ResourceProvisionerSimple;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.builders.PeBuilder;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;

public class HostBuilder
implements Builder {
    private double mips = 2000.0;
    private int pes = 1;
    private final List<Host> hosts;
    private Function<List<Pe>, Host> hostCreationFunction;
    private EventListener<HostUpdatesVmsProcessingEventInfo> onUpdateVmsProcessingListener = EventListener.NULL;
    private Supplier<VmScheduler> vmSchedulerSupplier;

    public HostBuilder() {
        this.hosts = new ArrayList<Host>();
        this.hostCreationFunction = this::defaultHostCreationFunction;
    }

    public HostBuilder create() {
        return this.create(1);
    }

    public HostBuilder create(int amount) {
        this.validateAmount(amount);
        for (int i = 0; i < amount; ++i) {
            List<Pe> peList = new PeBuilder().create(this.pes, this.mips);
            Host host = this.hostCreationFunction.apply(peList);
            if (this.vmSchedulerSupplier != null) {
                host.setVmScheduler(this.vmSchedulerSupplier.get());
            }
            this.hosts.add(host);
        }
        return this;
    }

    public List<Host> getHosts() {
        return this.hosts;
    }

    private Host defaultHostCreationFunction(List<Pe> peList) {
        return new HostSimple(peList).setRamProvisioner(new ResourceProvisionerSimple()).setBwProvisioner(new ResourceProvisionerSimple()).addOnUpdateProcessingListener(this.onUpdateVmsProcessingListener);
    }

    public double getMips() {
        return this.mips;
    }

    public HostBuilder setMips(double defaultMIPS) {
        this.mips = defaultMIPS;
        return this;
    }

    public int getPes() {
        return this.pes;
    }

    public HostBuilder setPes(int defaultPEs) {
        this.pes = defaultPEs;
        return this;
    }

    public void setHostCreationFunction(Function<List<Pe>, Host> hostCreationFunction) {
        this.hostCreationFunction = Objects.requireNonNull(hostCreationFunction);
    }

    public HostBuilder setOnUpdateVmsProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        this.onUpdateVmsProcessingListener = Objects.requireNonNull(listener);
        return this;
    }

    public HostBuilder setVmSchedulerSupplier(Supplier<VmScheduler> vmSchedulerSupplier) {
        this.vmSchedulerSupplier = Objects.requireNonNull(vmSchedulerSupplier);
        return this;
    }
}

