/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudsimplus.builders.tables.AbstractTableColumn;
import org.cloudsimplus.builders.tables.Table;

public class CsvTableColumn
extends AbstractTableColumn {
    public static final String DATA_COL_SEPARATOR_FORMAT = "%s%s";

    public CsvTableColumn(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public CsvTableColumn(String title) {
        this(null, title, "");
    }

    public CsvTableColumn(Table table, String title, String subTitle) {
        super(table, title, subTitle);
    }

    public CsvTableColumn(Table table, String title) {
        super(table, title);
    }

    @Override
    protected String generateHeader(String str) {
        if (this.isLastColumn()) {
            return str;
        }
        return String.format(DATA_COL_SEPARATOR_FORMAT, str, this.getTable().getColumnSeparator());
    }

    @Override
    public String generateData(Object data) {
        if (this.isLastColumn()) {
            return super.generateData(data);
        }
        return String.format(DATA_COL_SEPARATOR_FORMAT, super.generateData(data), this.getTable().getColumnSeparator());
    }

    protected String alignStringRight(String str) {
        String fmt = String.format("%%%ds", this.generateTitleHeader().length());
        return String.format(fmt, str);
    }
}

