/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudsimplus.builders.tables.MarkdownTable;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableColumn;

public abstract class TableBuilderAbstract<T> {
    private List<? extends T> list;
    private final Map<TableColumn, Function<T, Object>> columnsDataFunctions;
    private Table table;

    public TableBuilderAbstract(List<? extends T> list) {
        this(list, new MarkdownTable());
    }

    public TableBuilderAbstract(List<? extends T> list, Table table) {
        this.setTable(table);
        this.setObjectList(list);
        this.columnsDataFunctions = new HashMap<TableColumn, Function<T, Object>>();
        this.createTableColumns();
    }

    protected final TableBuilderAbstract<T> setObjectList(List<? extends T> list) {
        this.list = Objects.requireNonNull(list);
        return this;
    }

    public TableBuilderAbstract<T> setTitle(String title) {
        this.table.setTitle(title);
        return this;
    }

    protected Table getTable() {
        return this.table;
    }

    public final TableBuilderAbstract<T> column(int index, Consumer<TableColumn> consumer) {
        Objects.requireNonNull(consumer);
        consumer.accept(this.table.getColumns().get(index));
        return this;
    }

    protected final TableBuilderAbstract<T> setTable(Table table) {
        this.table = Objects.requireNonNull(table);
        return this;
    }

    public TableBuilderAbstract<T> addColumn(TableColumn col, Function<T, Object> dataFunction) {
        return this.addColumn(this.getTable().getColumns().size(), col, dataFunction);
    }

    public final TableBuilderAbstract<T> removeColumn(int ... indexes) {
        for (int i : indexes) {
            this.removeColumn(i);
        }
        return this;
    }

    public final TableBuilderAbstract<T> removeColumn(int index) {
        this.getTable().getColumns().remove(index);
        return this;
    }

    public TableBuilderAbstract<T> addColumn(int index, TableColumn col, Function<T, Object> dataFunction) {
        Objects.requireNonNull(col);
        Objects.requireNonNull(dataFunction);
        col.setTable(this.getTable());
        this.getTable().addColumn(index, col);
        this.columnsDataFunctions.put(col, dataFunction);
        return this;
    }

    protected abstract void createTableColumns();

    public void build() {
        if (this.getTable().getTitle().isEmpty()) {
            this.getTable().setTitle("SIMULATION RESULTS");
        }
        this.list.forEach(cloudlet -> this.addDataToRow(cloudlet, this.getTable().newRow()));
        this.getTable().print();
    }

    protected void addDataToRow(T object, List<Object> row) {
        this.getTable().getColumns().forEach(col -> row.add(this.columnsDataFunctions.get(col).apply(object)));
    }

    protected TableBuilderAbstract<T> addColumnDataFunction(TableColumn col, Function<T, Object> function) {
        this.columnsDataFunctions.put(Objects.requireNonNull(col), Objects.requireNonNull(function));
        return this;
    }
}

