/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.TaskEvent;

public enum TaskEventType {
    SUBMIT{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            TaskEvent event = reader.createTaskEventFromTraceLine();
            DatacenterBroker broker = reader.getOrCreateBroker(event.getUserName());
            if (!reader.allowCloudletCreation()) {
                return false;
            }
            Cloudlet cloudlet = reader.createCloudlet(event);
            cloudlet.setId(event.getUniqueTaskId());
            cloudlet.setJobId(event.getJobId());
            double delay = (Double)GoogleTaskEventsTraceReader.FieldIndex.TIMESTAMP.getValue(reader);
            cloudlet.setSubmissionDelay(delay);
            if (delay > 0.0) {
                cloudlet.setStatus(Cloudlet.Status.FROZEN);
            }
            if (reader.isAutoSubmitCloudlets()) {
                broker.submitCloudlet(cloudlet);
            }
            return reader.addAvailableObject(cloudlet);
        }
    }
    ,
    SCHEDULE{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(23);
        }
    }
    ,
    EVICT{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(19);
        }
    }
    ,
    FAIL{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(24);
        }
    }
    ,
    FINISH{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(-25);
        }
    }
    ,
    KILL{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(18);
        }
    }
    ,
    LOST{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    }
    ,
    UPDATE_PENDING{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    }
    ,
    UPDATE_RUNNING{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    };


    public static TaskEventType getValue(int ordinal) {
        return TaskEventType.values()[ordinal];
    }

    protected abstract boolean process(GoogleTaskEventsTraceReader var1);
}

