/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.migration;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigrationStaticThreshold;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;

public class VmAllocationPolicyMigrationFirstFitStaticThreshold
extends VmAllocationPolicyMigrationStaticThreshold {
    private int lastHostIndex;

    public VmAllocationPolicyMigrationFirstFitStaticThreshold(VmSelectionPolicy vmSelectionPolicy) {
        this(vmSelectionPolicy, 0.9);
    }

    public VmAllocationPolicyMigrationFirstFitStaticThreshold(VmSelectionPolicy vmSelectionPolicy, double overUtilizationThreshold) {
        this(vmSelectionPolicy, overUtilizationThreshold, null);
    }

    public VmAllocationPolicyMigrationFirstFitStaticThreshold(VmSelectionPolicy vmSelectionPolicy, double overUtilizationThreshold, BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        super(vmSelectionPolicy, overUtilizationThreshold, findHostForVmFunction);
    }

    @Override
    protected Optional<Host> findHostForVmInternal(Vm vm, Predicate<Host> predicate) {
        List hostList = this.getHostList();
        int maxTries = hostList.size();
        for (int i = 0; i < maxTries; ++i) {
            Host host = (Host)hostList.get(this.lastHostIndex);
            if (predicate.test(host)) {
                return Optional.of(host);
            }
            ++this.lastHostIndex;
            this.lastHostIndex %= this.getHostList().size();
        }
        return Optional.empty();
    }
}

