/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import java.util.Comparator;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.vms.Vm;

public class DatacenterBrokerBestFit
extends DatacenterBrokerSimple {
    public DatacenterBrokerBestFit(CloudSim simulation) {
        super(simulation);
    }

    @Override
    public Vm defaultVmMapper(Cloudlet cloudlet) {
        if (cloudlet.isBoundToVm()) {
            return cloudlet.getVm();
        }
        Vm mappedVm = this.getVmCreatedList().stream().filter(vm -> vm.getExpectedFreePesNumber() >= cloudlet.getNumberOfPes()).min(Comparator.comparingLong(Vm::getExpectedFreePesNumber)).orElse(Vm.NULL);
        if (Vm.NULL.equals(mappedVm)) {
            LOGGER.warn("{}: {}: {} (PEs: {}) couldn't be mapped to any suitable VM.", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, cloudlet.getNumberOfPes()});
        } else {
            LOGGER.trace("{}: {}: {} (PEs: {}) mapped to {} (available PEs: {}, tot PEs: {})", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, cloudlet.getNumberOfPes(), mappedVm, mappedVm.getExpectedFreePesNumber(), mappedVm.getFreePesNumber()});
        }
        return mappedVm;
    }
}

