/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets;

import java.util.Objects;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSimTag;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.CloudSimEvent;

public class CloudletExecution {
    public static final CloudletExecution NULL = new CloudletExecution(Cloudlet.NULL);
    private final Cloudlet cloudlet;
    private double fileTransferTime;
    private final double arrivalTime;
    private double finishedTime;
    private double overSubscriptionDelay;
    private double finishRequestTime;
    private long instructionsFinishedSoFar;
    private double startExecTime;
    private double lastProcessingTime;
    private double totalCompletionTime;
    private double virtualRuntime;
    private double timeSlice;
    private double lastAllocatedMips;

    public CloudletExecution(Cloudlet cloudlet) {
        this.cloudlet = cloudlet;
        this.arrivalTime = cloudlet.registerArrivalInDatacenter();
        this.finishedTime = -1.0;
        this.lastProcessingTime = -1.0;
        this.totalCompletionTime = 0.0;
        this.startExecTime = 0.0;
        this.virtualRuntime = 0.0;
        this.instructionsFinishedSoFar = cloudlet.getFinishedLengthSoFar() * 1000000L;
    }

    public long getCloudletLength() {
        return this.cloudlet.getLength();
    }

    public long getNumberOfPes() {
        return this.cloudlet.getNumberOfPes();
    }

    public boolean setStatus(Cloudlet.Status newStatus) {
        Cloudlet.Status prevStatus = this.cloudlet.getStatus();
        if (prevStatus.equals((Object)newStatus)) {
            return false;
        }
        double clock = this.cloudlet.getSimulation().clock();
        this.cloudlet.setStatus(newStatus);
        if (prevStatus == Cloudlet.Status.INEXEC && CloudletExecution.isNotRunning(newStatus)) {
            this.totalCompletionTime += clock - this.startExecTime;
            return true;
        }
        if (prevStatus == Cloudlet.Status.RESUMED && newStatus == Cloudlet.Status.SUCCESS) {
            this.totalCompletionTime += clock - this.startExecTime;
            return true;
        }
        this.startOrResumeCloudlet(newStatus, prevStatus);
        return true;
    }

    private void startOrResumeCloudlet(Cloudlet.Status newStatus, Cloudlet.Status oldStatus) {
        double clock = this.cloudlet.getSimulation().clock();
        if (newStatus == Cloudlet.Status.INEXEC || this.isTryingToResumePausedCloudlet(newStatus, oldStatus)) {
            this.startExecTime = clock;
            if (this.cloudlet.getExecStartTime() == 0.0) {
                this.cloudlet.setExecStartTime(this.startExecTime);
            }
        }
    }

    private boolean isTryingToResumePausedCloudlet(Cloudlet.Status newStatus, Cloudlet.Status oldStatus) {
        return newStatus == Cloudlet.Status.RESUMED && oldStatus == Cloudlet.Status.PAUSED;
    }

    private static boolean isNotRunning(Cloudlet.Status status) {
        return status == Cloudlet.Status.CANCELED || status == Cloudlet.Status.PAUSED || status == Cloudlet.Status.SUCCESS;
    }

    public long getRemainingCloudletLength() {
        long absLength = Math.abs(this.cloudlet.getLength());
        double miFinishedSoFar = (double)this.instructionsFinishedSoFar / 1000000.0;
        if (this.cloudlet.getLength() > 0L) {
            return (long)Math.max((double)absLength - miFinishedSoFar, 0.0);
        }
        if ((double)absLength - miFinishedSoFar == 0.0) {
            return absLength;
        }
        return (long)Math.min(Math.abs((double)absLength - miFinishedSoFar), (double)absLength);
    }

    public void finalizeCloudlet() {
        double wallClockTime = this.cloudlet.getSimulation().clock() - this.arrivalTime;
        this.cloudlet.setWallClockTime(wallClockTime, this.totalCompletionTime);
        long finishedLengthMI = this.cloudlet.getStatus() == Cloudlet.Status.SUCCESS ? this.cloudlet.getLength() : this.instructionsFinishedSoFar / 1000000L;
        this.cloudlet.addFinishedLengthSoFar(finishedLengthMI);
    }

    public void updateProcessing(double partialFinishedInstructions) {
        Simulation simulation = this.cloudlet.getSimulation();
        this.setLastProcessingTime(simulation.clock());
        boolean terminate = simulation.isTimeToTerminateSimulationUnderRequest();
        if (partialFinishedInstructions == 0.0 && !terminate) {
            return;
        }
        this.instructionsFinishedSoFar = (long)((double)this.instructionsFinishedSoFar + partialFinishedInstructions);
        double partialFinishedMI = partialFinishedInstructions / 1000000.0;
        this.cloudlet.addFinishedLengthSoFar((long)partialFinishedMI);
        if (this.finishRequestTime <= 0.0 && terminate && this.cloudlet.getLength() < 0L) {
            this.finishRequestTime = simulation.clock();
            simulation.sendFirst(new CloudSimEvent(this.cloudlet.getBroker(), CloudSimTag.CLOUDLET_FINISH, this.cloudlet));
        }
    }

    public double getCloudletArrivalTime() {
        return this.arrivalTime;
    }

    public double getFinishTime() {
        return this.finishedTime;
    }

    public void setFinishTime(double time) {
        if (time < 0.0) {
            return;
        }
        this.finishedTime = time;
    }

    public Cloudlet getCloudlet() {
        return this.cloudlet;
    }

    public long getCloudletId() {
        return this.cloudlet.getId();
    }

    public double getFileTransferTime() {
        return this.fileTransferTime;
    }

    public void setFileTransferTime(double fileTransferTime) {
        this.fileTransferTime = fileTransferTime;
    }

    public double getLastProcessingTime() {
        return this.lastProcessingTime;
    }

    public void setLastProcessingTime(double lastProcessingTime) {
        this.lastProcessingTime = lastProcessingTime;
        this.cloudlet.notifyOnUpdateProcessingListeners(lastProcessingTime);
    }

    public double getVirtualRuntime() {
        return this.virtualRuntime;
    }

    public double addVirtualRuntime(double timeToAdd) {
        if (timeToAdd >= 0.0) {
            this.setVirtualRuntime(this.virtualRuntime + timeToAdd);
        }
        return this.virtualRuntime;
    }

    public void setVirtualRuntime(double virtualRuntime) {
        this.virtualRuntime = virtualRuntime;
    }

    public double getTimeSlice() {
        return this.timeSlice;
    }

    public void setTimeSlice(double timeSlice) {
        this.timeSlice = timeSlice;
    }

    public String toString() {
        return String.format("Cloudlet %d", this.cloudlet.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof CloudletExecution)) return false;
        CloudletExecution that = (CloudletExecution)obj;
        if (that.cloudlet.getId() != this.cloudlet.getId()) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.cloudlet.getId());
    }

    public double getLastAllocatedMips() {
        return this.lastAllocatedMips;
    }

    public void setLastAllocatedMips(double lastAllocatedMips) {
        if (lastAllocatedMips > 0.0) {
            this.lastAllocatedMips = lastAllocatedMips;
        }
    }

    public double getOverSubscriptionDelay() {
        return this.overSubscriptionDelay;
    }

    public double getExpectedFinishTime() {
        return this.getCloudlet().getActualCpuTime() - this.overSubscriptionDelay;
    }

    public boolean hasOverSubscription() {
        return this.overSubscriptionDelay > 0.0;
    }

    public void incOverSubscriptionDelay(double newDelay) {
        if (newDelay < 0.0) {
            throw new IllegalArgumentException("Over-subscription delay cannot be negative");
        }
        this.overSubscriptionDelay += newDelay;
    }
}

