/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets.network;

import org.cloudbus.cloudsim.cloudlets.network.CloudletExecutionTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletReceiveTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletSendTask;
import org.cloudbus.cloudsim.cloudlets.network.NetworkCloudlet;
import org.cloudbus.cloudsim.core.Identifiable;

public abstract class CloudletTask
implements Identifiable {
    private boolean finished;
    private long id;
    private double startTime;
    private double finishTime;
    private long memory;
    private NetworkCloudlet cloudlet;

    public CloudletTask(int id) {
        this.id = id;
        this.startTime = -1.0;
        this.finishTime = -1.0;
        this.memory = 0L;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public CloudletTask setId(int id) {
        this.id = id;
        return this;
    }

    public long getMemory() {
        return this.memory;
    }

    public CloudletTask setMemory(long memory) {
        this.memory = memory;
        return this;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public CloudletTask setStartTime(double startTime) {
        this.startTime = startTime;
        return this;
    }

    public NetworkCloudlet getCloudlet() {
        return this.cloudlet;
    }

    public CloudletTask setCloudlet(NetworkCloudlet cloudlet) {
        this.cloudlet = cloudlet;
        return this;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isActive() {
        return !this.isFinished();
    }

    protected void setFinished(boolean finished) {
        if (this.finished && !finished) {
            throw new IllegalStateException("The task is already finished. You cannot set it as unfinished.");
        }
        if (!this.finished && finished) {
            this.finishTime = this.cloudlet.getSimulation().clock();
        }
        this.finished = finished;
    }

    public double getExecutionTime() {
        return this.finished ? this.finishTime - this.startTime : -1.0;
    }

    public double getFinishTime() {
        return this.finishTime;
    }

    public boolean isExecutionTask() {
        return this instanceof CloudletExecutionTask;
    }

    public boolean isSendTask() {
        return this instanceof CloudletSendTask;
    }

    public boolean isReceiveTask() {
        return this instanceof CloudletReceiveTask;
    }
}

