/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.CloudSimTag;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudInformationService
extends CloudSimEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudInformationService.class.getSimpleName());
    private final List<Datacenter> datacenterList = new ArrayList<Datacenter>();
    private final Set<CloudInformationService> cisList = new TreeSet<CloudInformationService>();

    CloudInformationService(CloudSim simulation) {
        super(simulation);
    }

    @Override
    protected void startInternal() {
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case REGISTER_REGIONAL_CIS: {
                this.cisList.add((CloudInformationService)evt.getData());
                break;
            }
            case REQUEST_REGIONAL_CIS: {
                super.send(evt.getSource(), 0.0, evt.getTag(), this.cisList);
                break;
            }
            case DC_REGISTRATION_REQUEST: {
                this.datacenterList.add((Datacenter)evt.getData());
                break;
            }
            case DC_LIST_REQUEST: {
                super.send(evt.getSource(), 0.0, evt.getTag(), this.datacenterList);
            }
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        LOGGER.info("{}: Notify all CloudSim Plus entities to shutdown.{}", (Object)super.getName(), (Object)System.lineSeparator());
        this.signalShutdown(this.datacenterList);
        this.signalShutdown(this.cisList);
        this.datacenterList.clear();
        this.cisList.clear();
    }

    public List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    private void signalShutdown(Collection<? extends SimEntity> list) {
        if (list == null) {
            return;
        }
        list.forEach(entity -> super.send((SimEntity)entity, 0.0, CloudSimTag.SIMULATION_END));
    }
}

